/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.idtoken;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.OAuthAuthorizationService;
import org.iplass.mtp.impl.auth.oauth.code.AuthorizationCode;
import org.iplass.mtp.impl.auth.oauth.jwt.CertificateKeyPair;
import org.iplass.mtp.impl.auth.oauth.jwt.JwtProcessor;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;

public class IdToken {
    private Map<String, Object> userInfoClaims;
    private String aud;
    private long exp;
    private long iat;
    private long authTime;
    private String nonce;
    private String at;
    private String c;
    private OAuthAuthorizationService service;

    public IdToken(AuthorizationCode code, AccessToken accessToken, MetaOAuthAuthorization.OAuthAuthorizationRuntime server, MetaOAuthClient.OAuthClientRuntime client, OAuthAuthorizationService service) {
        this.service = service;
        this.userInfoClaims = server.userInfo(accessToken, client);
        this.aud = client.getMetaData().getName();
        this.iat = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        this.exp = this.iat + service.getIdTokenLifetimeSeconds();
        this.authTime = code.getRequest().getAuthTime();
        this.nonce = code.getRequest().getNonce();
        this.at = accessToken.getTokenEncoded();
        this.c = code.getCodeValue();
    }

    public String getTokenEncoded(String issuerId) {
        JwtProcessor processor = this.service.getJwtProcessor();
        if (this.service.getJwtKeyStore() == null) {
            throw new NullPointerException("jwtKeyStore not defined on OAuthAuthorizationService.");
        }
        CertificateKeyPair key = this.service.getJwtKeyStore().getCertificateKeyPair();
        HashMap<String, Object> claims = new HashMap<String, Object>(this.userInfoClaims);
        claims.put("iss", issuerId);
        claims.put("aud", this.aud);
        claims.put("exp", this.exp);
        claims.put("iat", this.iat);
        claims.put("auth_time", this.authTime);
        if (this.nonce != null) {
            claims.put("nonce", this.nonce);
        }
        if (this.at != null || this.c != null) {
            String jwtSignAlg = processor.preferredAlgorithm(key);
            String hashAlg = this.hashAlg(jwtSignAlg);
            try {
                MessageDigest md = MessageDigest.getInstance(hashAlg);
                if (this.at != null) {
                    claims.put("at_hash", this.hashValue(this.at, md));
                }
                if (this.c != null) {
                    claims.put("c_hash", this.hashValue(this.c, md));
                }
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                throw new SystemException((Throwable)e);
            }
        }
        return processor.encode(claims, key);
    }

    private String hashValue(String target, MessageDigest md) throws UnsupportedEncodingException {
        byte[] b = md.digest(target.getBytes("UTF-8"));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(Arrays.copyOf(b, b.length / 2));
    }

    private String hashAlg(String jwtSignAlg) {
        switch (jwtSignAlg) {
            case "HS256": 
            case "ES256": 
            case "RS256": 
            case "PS256": {
                return "SHA-256";
            }
            case "HS384": 
            case "ES384": 
            case "RS384": 
            case "PS384": {
                return "SHA-384";
            }
            case "HS512": 
            case "ES512": 
            case "RS512": 
            case "PS512": {
                return "SHA-512";
            }
        }
        throw new IllegalArgumentException("unknown jwtSignAlg:" + jwtSignAlg);
    }

    public Map<String, Object> getUserInfoClaims() {
        return this.userInfoClaims;
    }

    public String getAud() {
        return this.aud;
    }

    public long getExp() {
        return this.exp;
    }

    public long getIat() {
        return this.iat;
    }

    public long getAuthTime() {
        return this.authTime;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getAt() {
        return this.at;
    }

    public String getC() {
        return this.c;
    }
}

