/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.jwt;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECPoint;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import org.iplass.mtp.impl.auth.oauth.jwt.EllipticCurveSpec;

public class CertificateKeyPair {
    private final String keyId;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final X509Certificate certificate;

    public CertificateKeyPair(String keyId, X509Certificate certificate, PrivateKey privateKey) {
        this.keyId = keyId;
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.publicKey = certificate.getPublicKey();
    }

    public CertificateKeyPair(String keyId, PublicKey publicKey, PrivateKey privateKey) {
        this.keyId = keyId;
        this.certificate = null;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public Map<String, Object> toPublicJwkMap(String alg) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("kid", this.keyId);
        map.put("kty", this.privateKey.getAlgorithm());
        map.put("use", "sig");
        map.put("alg", alg);
        if (this.publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPubKey = (RSAPublicKey)this.publicKey;
            map.put("n", CertificateKeyPair.intToBase64(rsaPubKey.getModulus(), -1));
            map.put("e", CertificateKeyPair.intToBase64(rsaPubKey.getPublicExponent(), -1));
        } else if (this.publicKey instanceof ECPublicKey) {
            ECPublicKey ecPubKey = (ECPublicKey)this.publicKey;
            EllipticCurveSpec spec = EllipticCurveSpec.preferredSpec(ecPubKey.getParams().getOrder().bitLength());
            map.put("crv", spec.getCurveName());
            ECPoint w = ecPubKey.getW();
            map.put("x", CertificateKeyPair.intToBase64(w.getAffineX(), spec.getOctetStringLength()));
            map.put("y", CertificateKeyPair.intToBase64(w.getAffineY(), spec.getOctetStringLength()));
        }
        return map;
    }

    static String intToBase64(BigInteger num, int length) {
        byte[] bb;
        byte[] b = num.toByteArray();
        if (num.bitLength() % 8 == 0 && b[0] == 0 && b.length != 0) {
            bb = new byte[b.length - 1];
            System.arraycopy(b, 1, bb, 0, bb.length);
            b = bb;
        }
        if (length > 0 && length > b.length) {
            bb = new byte[length];
            System.arraycopy(b, 0, bb, length - b.length, b.length);
            b = bb;
        }
        return Base64.getUrlEncoder().withoutPadding().encodeToString(b);
    }
}

