/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.jwt;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Map;
import org.iplass.mtp.impl.auth.oauth.jwt.CertificateKeyPair;
import org.iplass.mtp.impl.auth.oauth.jwt.JwtProcessor;

public class JjwtProcesor
implements JwtProcessor {
    private boolean useRsaSsaPss;

    public boolean isUseRsaSsaPss() {
        return this.useRsaSsaPss;
    }

    public void setUseRsaSsaPss(boolean useRsaSsaPss) {
        this.useRsaSsaPss = useRsaSsaPss;
    }

    @Override
    public String encode(Map<String, Object> claims, CertificateKeyPair key) {
        return Jwts.builder().addClaims(claims).setHeaderParam("kid", (Object)key.getKeyId()).signWith((Key)key.getPrivateKey()).compact();
    }

    @Override
    public String preferredAlgorithm(CertificateKeyPair key) {
        SignatureAlgorithm alg = SignatureAlgorithm.forSigningKey((Key)key.getPrivateKey());
        if (this.useRsaSsaPss) {
            if (alg == SignatureAlgorithm.RS256) {
                alg = SignatureAlgorithm.PS256;
            } else if (alg == SignatureAlgorithm.RS384) {
                alg = SignatureAlgorithm.PS384;
            } else if (alg == SignatureAlgorithm.RS512) {
                alg = SignatureAlgorithm.PS512;
            }
        }
        return alg.getValue();
    }
}

