/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.token.opaque;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import org.iplass.mtp.auth.oauth.AccessTokenInfo;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.OAuthAuthorizationService;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;
import org.iplass.mtp.impl.auth.oauth.token.OAuthAccessTokenStore;
import org.iplass.mtp.impl.auth.oauth.token.RefreshToken;
import org.iplass.mtp.impl.auth.oauth.token.opaque.AccessTokenHandler;
import org.iplass.mtp.impl.auth.oauth.token.opaque.AccessTokenMement;
import org.iplass.mtp.impl.auth.oauth.token.opaque.OAuthServiceHolder;
import org.iplass.mtp.impl.auth.oauth.token.opaque.OpaqueAccessToken;
import org.iplass.mtp.impl.auth.oauth.token.opaque.OpaqueRefreshToken;
import org.iplass.mtp.impl.auth.oauth.token.opaque.RefreshTokenMement;
import org.iplass.mtp.impl.auth.oauth.token.opaque.TokenCreationStrategy;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceInitListener;
import org.iplass.mtp.spi.ServiceRegistry;

public class OpaqueOAuthAccessTokenStore
implements OAuthAccessTokenStore,
ServiceInitListener<OAuthAuthorizationService> {
    private String authTokenType = "OAT";
    private String seriesHashSalt = "iPLAss#OAT2018";
    private String seriesHashAlgorithm = "SHA-256";
    private TokenCreationStrategy tokenCreationStrategy;
    private AccessTokenHandler accessTokenHandler;

    public String getAuthTokenType() {
        return this.authTokenType;
    }

    public void setAuthTokenType(String authTokenType) {
        this.authTokenType = authTokenType;
    }

    public TokenCreationStrategy getTokenCreationStrategy() {
        return this.tokenCreationStrategy;
    }

    public void setTokenCreationStrategy(TokenCreationStrategy tokenCreationStrategy) {
        this.tokenCreationStrategy = tokenCreationStrategy;
    }

    public String getSeriesHashSalt() {
        return this.seriesHashSalt;
    }

    public void setSeriesHashSalt(String seriesHashSalt) {
        this.seriesHashSalt = seriesHashSalt;
    }

    public String getSeriesHashAlgorithm() {
        return this.seriesHashAlgorithm;
    }

    public void setSeriesHashAlgorithm(String seriesHashAlgorithm) {
        this.seriesHashAlgorithm = seriesHashAlgorithm;
    }

    @Override
    public AccessToken getAccessTokenByUserOid(MetaOAuthClient.OAuthClientRuntime client, String userOid) {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        AuthToken authToken = this.accessTokenHandler.authTokenStore().getBySeries(tenantId, this.accessTokenHandler.getType(), this.toSeriesString(client, userOid));
        if (authToken == null) {
            return null;
        }
        AccessTokenMement mement = (AccessTokenMement)authToken.getDetails();
        return new OpaqueAccessToken(client, mement, authToken.getSeries(), null, authToken.getStartDate().getTime(), null);
    }

    @Override
    public AccessToken getAccessToken(String tokenString) {
        AuthToken authToken = new AuthToken(tokenString);
        String tokenPart = authToken.getToken();
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        authToken = this.accessTokenHandler.authTokenStore().getBySeries(tenantId, authToken.getType(), authToken.getSeries());
        if (authToken == null) {
            return null;
        }
        if (!this.accessTokenHandler.checkTokenValid(tokenPart, authToken)) {
            return null;
        }
        AccessTokenMement mement = (AccessTokenMement)authToken.getDetails();
        MetaOAuthClient.OAuthClientRuntime client = (MetaOAuthClient.OAuthClientRuntime)OAuthServiceHolder.client.getRuntimeById(mement.getClientMetaDataId());
        return new OpaqueAccessToken(client, mement, authToken.getSeries(), null, authToken.getStartDate().getTime(), null);
    }

    @Override
    public AccessToken createAccessToken(MetaOAuthClient.OAuthClientRuntime client, RefreshToken refreshToken) {
        AuthToken authToken = this.tokenCreationStrategy.create(client, this.accessTokenHandler, (OpaqueRefreshToken)refreshToken);
        if (authToken == null) {
            return null;
        }
        AccessTokenMement mement = (AccessTokenMement)authToken.getDetails();
        OpaqueAccessToken accessToken = new OpaqueAccessToken(client, mement, authToken.getSeries(), authToken.encodeToken(), authToken.getStartDate().getTime(), null);
        return accessToken;
    }

    @Override
    public AccessToken createAccessToken(MetaOAuthClient.OAuthClientRuntime client, String userOid, List<String> scopes) {
        AccessTokenInfo ati = new AccessTokenInfo();
        ati.setClientName(client.getMetaData().getName());
        ati.setGrantedScopes(scopes);
        ati.setType(this.accessTokenHandler.getType());
        AuthToken authToken = this.tokenCreationStrategy.create(client, this.accessTokenHandler, userOid, ati);
        AccessTokenMement mement = (AccessTokenMement)authToken.getDetails();
        OpaqueRefreshToken refreshToken = null;
        if (mement.getRefreshToken() != null) {
            refreshToken = new OpaqueRefreshToken(client, (RefreshTokenMement)mement.getRefreshToken().getDetails(), mement.getRefreshToken().getSeries(), mement.getRefreshToken().encodeToken());
        }
        OpaqueAccessToken accessToken = new OpaqueAccessToken(client, (AccessTokenMement)authToken.getDetails(), authToken.getSeries(), authToken.encodeToken(), authToken.getStartDate().getTime(), refreshToken);
        return accessToken;
    }

    public void inited(OAuthAuthorizationService service, Config config) {
        AuthTokenService ats = (AuthTokenService)ServiceRegistry.getRegistry().getService(AuthTokenService.class);
        this.accessTokenHandler = (AccessTokenHandler)ats.getHandler(this.authTokenType);
        try {
            MessageDigest.getInstance(this.seriesHashAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceConfigrationException("invalid messageDigestAlgorithm", (Throwable)e);
        }
    }

    public void destroyed() {
    }

    String toSeriesString(MetaOAuthClient.OAuthClientRuntime client, String ownerId) {
        try {
            MessageDigest md = MessageDigest.getInstance(this.seriesHashAlgorithm);
            String msg = ownerId + "-" + client.getMetaData().getId() + "-" + ExecuteContext.getCurrentContext().getClientTenantId() + "-" + this.seriesHashSalt;
            byte[] bytes = md.digest(msg.getBytes("UTF-8"));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RefreshToken getRefreshToken(String tokenString) {
        AuthToken authToken = new AuthToken(tokenString);
        String tokenPart = authToken.getToken();
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        authToken = this.accessTokenHandler.refreshTokenHandler().authTokenStore().getBySeries(tenantId, authToken.getType(), authToken.getSeries());
        if (authToken == null) {
            return null;
        }
        if (!this.accessTokenHandler.refreshTokenHandler().checkTokenValid(tokenPart, authToken)) {
            return null;
        }
        RefreshTokenMement mement = (RefreshTokenMement)authToken.getDetails();
        MetaOAuthClient.OAuthClientRuntime client = (MetaOAuthClient.OAuthClientRuntime)OAuthServiceHolder.client.getRuntimeById(mement.getClientMetaDataId());
        return new OpaqueRefreshToken(client, mement, authToken.getSeries(), null);
    }

    @Override
    public void revokeToken(MetaOAuthClient.OAuthClientRuntime client, String tokenString, String tokenTypeHint) {
        AuthToken authToken = new AuthToken(tokenString);
        String type = authToken.getType();
        if (type.equals(this.accessTokenHandler.getType())) {
            AccessToken at = this.getAccessToken(tokenString);
            if (!at.getClientId().equals(client.getMetaData().getName())) {
                return;
            }
        } else if (type.equals(this.accessTokenHandler.getRefreshTokenType())) {
            RefreshToken rt = this.getRefreshToken(tokenString);
            if (!rt.getClientId().equals(client.getMetaData().getName())) {
                return;
            }
        } else {
            return;
        }
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        this.accessTokenHandler.authTokenStore().deleteBySeries(tenantId, authToken.getType(), authToken.getSeries());
    }

    @Override
    public void revokeTokenByUserOid(String userOid) {
        this.accessTokenHandler.authTokenStore().delete(ExecuteContext.getCurrentContext().getClientTenantId(), this.accessTokenHandler.getType(), userOid);
    }
}

