/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.token.remote;

import java.util.Arrays;
import java.util.List;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;
import org.iplass.mtp.impl.auth.oauth.token.RefreshToken;
import org.iplass.mtp.impl.auth.oauth.token.remote.IntroResponse;

public class RemoteAccessToken
extends AccessToken {
    private String tokenEncoded;
    private User user;
    private List<String> grantedScopes;
    private String clientId;
    private String sub;
    private long expires;
    private long expiresIn;
    private long issuedAt;
    private long notBefore;
    private String audience;
    private String issuer;
    private String username;

    RemoteAccessToken(String tokenEncoded, IntroResponse jsonMap) {
        this.tokenEncoded = tokenEncoded;
        if (jsonMap.scope != null) {
            this.grantedScopes = Arrays.asList(jsonMap.scope.split(" "));
        }
        this.clientId = jsonMap.client_id;
        this.sub = jsonMap.sub;
        if (jsonMap.exp != null) {
            this.expires = jsonMap.exp;
            this.expiresIn = this.expires - System.currentTimeMillis() / 1000L;
        } else {
            this.expiresIn = 1L;
        }
        if (jsonMap.iat != null) {
            this.issuedAt = jsonMap.iat;
        }
        if (jsonMap.nbf != null) {
            this.notBefore = jsonMap.nbf;
        }
        this.audience = jsonMap.aud;
        this.issuer = jsonMap.iss;
        this.username = jsonMap.username;
        this.user = jsonMap.resource_owner;
        if (this.user == null) {
            this.user = new User();
            this.user.setOid(this.sub);
            this.user.setAccountId(this.sub);
            this.user.setName(this.username);
        }
    }

    public long getExpires() {
        return this.expires;
    }

    public String getAudience() {
        return this.audience;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getUsername() {
        return this.username;
    }

    public String getSub() {
        return this.sub;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public List<String> getGrantedScopes() {
        return this.grantedScopes;
    }

    @Override
    public String getTokenEncoded() {
        return this.tokenEncoded;
    }

    @Override
    public long getExpiresIn() {
        return this.expiresIn;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public RefreshToken getRefreshToken() {
        return null;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public long getExpirationTime() {
        return this.expires;
    }

    @Override
    public long getIssuedAt() {
        return this.issuedAt;
    }

    @Override
    public long getNotBefore() {
        return this.notBefore;
    }
}

