/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.report;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.iplass.mtp.impl.report.PoiReportingOutputModel;
import org.iplass.mtp.impl.report.ReportingEngine;
import org.iplass.mtp.impl.report.ReportingOutputModel;
import org.iplass.mtp.impl.report.ReportingType;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.template.report.MetaPoiReportOutputLogic;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.report.ReportOutputException;
import org.iplass.mtp.web.template.report.definition.PoiReportType;

public class PoiReportingEngine
implements ReportingEngine {
    private String[] supportFiles;

    @Override
    public ReportingOutputModel createOutputModel(byte[] binary, String type, String extension) throws Exception {
        return new PoiReportingOutputModel(binary, type, extension);
    }

    @Override
    public boolean isSupport(String type) {
        for (String supportFile : this.supportFiles) {
            if (!supportFile.equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void exportReport(WebRequestStack context, ReportingOutputModel model) throws Exception {
        PoiReportingOutputModel poiModel = (PoiReportingOutputModel)model;
        MetaPoiReportOutputLogic.PoiReportOutputLogicRuntime logicRuntime = poiModel.getLogicRuntime();
        if (logicRuntime != null) {
            logicRuntime.outputReport(context.getRequestContext(), poiModel.getBook());
        }
        try {
            String password = null;
            if (StringUtil.isNotEmpty((String)poiModel.getPasswordAttributeName())) {
                password = (String)context.getRequestContext().getAttribute(poiModel.getPasswordAttributeName());
            }
            poiModel.write((OutputStream)context.getResponse().getOutputStream(), password);
        }
        catch (IOException e) {
            throw new ReportOutputException(e);
        }
        catch (InvalidFormatException e) {
            throw new ReportOutputException(e);
        }
        catch (GeneralSecurityException e) {
            throw new ReportOutputException(e);
        }
    }

    @Override
    public String[] getSupportFiles() {
        return this.supportFiles;
    }

    public void setSupportFiles(String[] supportFiles) {
        this.supportFiles = supportFiles;
    }

    @Override
    public ReportingType getReportingType() {
        ReportingType type = new ReportingType();
        type.setName(PoiReportType.class.getName());
        type.setDisplayName("POI");
        return type;
    }
}

