/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tenant.web;

import java.io.Serializable;
import org.codehaus.groovy.GroovyBugError;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.MetaTenantConfig;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.web.TenantWebInfo;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaTenantWebInfo
extends MetaTenantConfig<TenantWebInfo> {
    private static final long serialVersionUID = -8722898685664541128L;
    private static final Logger logger = LoggerFactory.getLogger(MetaTenantWebInfo.class);
    private boolean usePreview;
    private String loginUrlSelector;
    private String reAuthUrlSelector;
    private String errorUrlSelector;
    private String homeUrl;
    private String urlForRequest;

    public boolean isUsePreview() {
        return this.usePreview;
    }

    public void setUsePreview(boolean usePreview) {
        this.usePreview = usePreview;
    }

    public String getLoginUrlSelector() {
        return this.loginUrlSelector;
    }

    public void setLoginUrlSelector(String loginUrlSelector) {
        this.loginUrlSelector = loginUrlSelector;
    }

    public String getReAuthUrlSelector() {
        return this.reAuthUrlSelector;
    }

    public void setReAuthUrlSelector(String reAuthUrlSelector) {
        this.reAuthUrlSelector = reAuthUrlSelector;
    }

    public String getErrorUrlSelector() {
        return this.errorUrlSelector;
    }

    public void setErrorUrlSelector(String errorUrlSelector) {
        this.errorUrlSelector = errorUrlSelector;
    }

    public void setHomeUrl(String homeUrl) {
        this.homeUrl = homeUrl;
    }

    public String getHomeUrl() {
        return this.homeUrl;
    }

    public String getUrlForRequest() {
        return this.urlForRequest;
    }

    public void setUrlForRequest(String urlForRequest) {
        this.urlForRequest = urlForRequest;
    }

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }

    public void applyConfig(TenantWebInfo definition) {
        this.setUsePreview(definition.isUsePreview());
        this.setLoginUrlSelector(definition.getLoginUrlSelector());
        this.setReAuthUrlSelector(definition.getReAuthUrlSelector());
        this.setErrorUrlSelector(definition.getErrorUrlSelector());
        this.setHomeUrl(definition.getHomeUrl());
        this.setUrlForRequest(definition.getUrlForRequest());
    }

    public TenantWebInfo currentConfig() {
        TenantWebInfo definition = new TenantWebInfo();
        definition.setUsePreview(this.usePreview);
        definition.setLoginUrlSelector(this.loginUrlSelector);
        definition.setReAuthUrlSelector(this.reAuthUrlSelector);
        definition.setErrorUrlSelector(this.errorUrlSelector);
        definition.setHomeUrl(this.getHomeUrl());
        definition.setUrlForRequest(this.getUrlForRequest());
        return definition;
    }

    public MetaTenantWebInfoRuntime createRuntime(MetaTenant.MetaTenantHandler tenantRuntime) {
        return new MetaTenantWebInfoRuntime(tenantRuntime);
    }

    public class MetaTenantWebInfoRuntime
    extends MetaTenantConfig.MetaTenantConfigRuntime {
        private static final String SCRIPT_PREFIX_LOGIN_URL_SELECTOR = "MetaTenantHandler_loginUrlSelector";
        private static final String SCRIPT_PREFIX_REAUTH_URL_SELECTOR = "MetaTenantHandler_reAuthUrlSelector";
        private static final String SCRIPT_PREFIX_ERROR_URL_SELECTOR = "MetaTenantHandler_errorUrlSelector";
        private Script loginUrlSelectorScript;
        private Script reAuthUrlSelectorScript;
        private Script errorUrlSelectorScript;

        public MetaTenantWebInfoRuntime(MetaTenant.MetaTenantHandler tenantRuntime) {
            super((MetaTenantConfig)MetaTenantWebInfo.this);
            TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
            ScriptEngine scriptEngine = tc.getScriptEngine();
            try {
                if (!StringUtil.isEmpty((String)MetaTenantWebInfo.this.loginUrlSelector)) {
                    this.loginUrlSelectorScript = scriptEngine.createScript(MetaTenantWebInfo.this.loginUrlSelector, "MetaTenantHandler_loginUrlSelector_" + tenantRuntime.getMetaData().getId());
                }
                if (!StringUtil.isEmpty((String)MetaTenantWebInfo.this.reAuthUrlSelector)) {
                    this.reAuthUrlSelectorScript = scriptEngine.createScript(MetaTenantWebInfo.this.reAuthUrlSelector, "MetaTenantHandler_reAuthUrlSelector_" + tenantRuntime.getMetaData().getId());
                }
                if (!StringUtil.isEmpty((String)MetaTenantWebInfo.this.errorUrlSelector)) {
                    this.errorUrlSelectorScript = scriptEngine.createScript(MetaTenantWebInfo.this.errorUrlSelector, "MetaTenantHandler_errorUrlSelector_" + tenantRuntime.getMetaData().getId());
                }
            }
            catch (NoClassDefFoundError | GroovyBugError e) {
                this.setIllegalStateException(new RuntimeException(e));
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        public MetaData getMetaData() {
            return MetaTenantWebInfo.this;
        }

        public void applyMetaDataToTenant(Tenant tenant) {
        }

        public String loginUrlSelector(RequestContext context, String path) {
            if (this.loginUrlSelectorScript == null) {
                return null;
            }
            ScriptContext sc = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine().newScriptContext();
            sc.setAttribute("request", (Object)context);
            sc.setAttribute("path", (Object)path);
            Object res = null;
            try {
                res = this.loginUrlSelectorScript.eval(sc);
            }
            catch (RuntimeException e) {
                logger.error("fail on LoginUrlSelector: " + e.getMessage(), (Throwable)e);
            }
            if (res == null) {
                return null;
            }
            return res.toString();
        }

        public String reAuthUrlSelector(RequestContext context, String path) {
            if (this.reAuthUrlSelectorScript == null) {
                return null;
            }
            ScriptContext sc = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine().newScriptContext();
            sc.setAttribute("request", (Object)context);
            sc.setAttribute("path", (Object)path);
            Object res = null;
            try {
                res = this.reAuthUrlSelectorScript.eval(sc);
            }
            catch (RuntimeException e) {
                logger.error("fail on ReAuthUrlSelector: " + e.getMessage(), (Throwable)e);
            }
            if (res == null) {
                return null;
            }
            return res.toString();
        }

        public String errorUrlSelector(Throwable exp, RequestContext context, String path) {
            if (this.errorUrlSelectorScript == null) {
                return null;
            }
            ScriptContext sc = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine().newScriptContext();
            sc.setAttribute("request", (Object)context);
            sc.setAttribute("path", (Object)path);
            sc.setAttribute("exception", (Object)exp);
            Object res = null;
            try {
                res = this.errorUrlSelectorScript.eval(sc);
            }
            catch (RuntimeException e) {
                logger.error("fail on ErrorUrlSelectorScript: " + e.getMessage(), (Throwable)e);
            }
            if (res == null) {
                return null;
            }
            return res.toString();
        }
    }
}

