/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.BoundedInputStream;
import org.iplass.mtp.impl.web.WebRequestStack;

public class RangeHeader {
    static final long UNSPEC = -1L;
    static final long NAN = -2L;
    public long start;
    public long end;
    public long totalSize;
    public boolean valid;

    public static RangeHeader getRangeHeader(WebRequestStack req, long contentSize) {
        String rangeValue = req.getRequest().getHeader("Range");
        if (rangeValue != null) {
            return new RangeHeader(rangeValue, contentSize);
        }
        return null;
    }

    public static long writeResponseHeader(WebRequestStack req, RangeHeader range, long contentSize) {
        req.getResponse().setHeader("Accept-Ranges", "bytes");
        if (range != null && range.valid) {
            req.getResponse().setStatus(206);
            req.getResponse().setHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.totalSize);
            return range.end - range.start + 1L;
        }
        return contentSize;
    }

    public static void writeResponseBody(InputStream is, OutputStream os, RangeHeader range) throws IOException {
        int count;
        if (range != null && range.valid) {
            is = new BoundedInputStream(is, range.end + 1L);
            is.skip(range.start);
        }
        byte[] buf = new byte[16384];
        while ((count = is.read(buf)) != -1) {
            os.write(buf, 0, count);
        }
        os.flush();
    }

    public RangeHeader(String value, long totalSize) {
        int splitIndex;
        this.totalSize = totalSize;
        if (value != null && value.startsWith("bytes=") && (splitIndex = value.indexOf(45)) >= 0) {
            this.start = this.toLong(value.substring(6, splitIndex));
            this.end = this.toLong(value.substring(splitIndex + 1));
        }
        if (this.start == -2L || this.end == -2L) {
            this.valid = false;
        } else {
            if (this.start == -1L) {
                this.start = totalSize - this.end;
                this.end = totalSize - 1L;
            } else if (this.end == -1L || this.end > totalSize - 1L) {
                this.end = totalSize - 1L;
            }
            this.valid = this.start <= this.end;
        }
    }

    private long toLong(String val) {
        if (val == null || val.length() == 0) {
            return -1L;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return -2L;
        }
    }
}

