/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import org.iplass.mtp.impl.web.CorsConfig;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;

public class RequestRestriction
implements ServiceInitListener<WebFrontendService> {
    private String pathPattern;
    private List<String> allowMethods;
    private List<String> allowContentTypes;
    private CorsConfig cors;
    private Long maxBodySize;
    private Long maxFileSize;
    private boolean force;
    private Pattern pathPatternCompile;
    private boolean allowAllMethods;
    private HashSet<String> allowMethodsHash;
    private boolean allowAllContentTypes;
    private MediaType[] allowContentTypesMT;

    public RequestRestriction copy() {
        RequestRestriction copy = new RequestRestriction();
        copy.pathPattern = this.pathPattern;
        if (this.allowMethods != null) {
            copy.allowMethods = new ArrayList<String>(this.allowMethods);
        }
        if (this.allowContentTypes != null) {
            copy.allowContentTypes = new ArrayList<String>(this.allowContentTypes);
        }
        if (this.cors != null) {
            copy.cors = this.cors.copy();
        }
        copy.maxBodySize = this.maxBodySize;
        copy.maxFileSize = this.maxFileSize;
        copy.force = this.force;
        copy.pathPatternCompile = this.pathPatternCompile;
        copy.allowAllMethods = this.allowAllMethods;
        copy.allowMethodsHash = this.allowMethodsHash;
        copy.allowAllContentTypes = this.allowAllContentTypes;
        copy.allowContentTypesMT = this.allowContentTypesMT;
        return copy;
    }

    public List<String> getAllowMethods() {
        return this.allowMethods;
    }

    public void setAllowMethods(List<String> allowMethods) {
        this.allowMethods = allowMethods;
    }

    public List<String> getAllowContentTypes() {
        return this.allowContentTypes;
    }

    public void setAllowContentTypes(List<String> allowContentTypes) {
        this.allowContentTypes = allowContentTypes;
    }

    public CorsConfig getCors() {
        return this.cors;
    }

    public void setCors(CorsConfig cors) {
        this.cors = cors;
    }

    public Long getMaxBodySize() {
        return this.maxBodySize;
    }

    public void setMaxBodySize(Long maxBodySize) {
        this.maxBodySize = maxBodySize;
    }

    public Long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(Long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public String getPathPattern() {
        return this.pathPattern;
    }

    public void setPathPattern(String pathPattern) {
        this.pathPattern = pathPattern;
    }

    public void init() {
        if (this.pathPattern != null) {
            if (this.pathPatternCompile == null || !this.pathPatternCompile.pattern().equals(this.pathPattern)) {
                this.pathPatternCompile = Pattern.compile(this.pathPattern);
            }
        } else {
            this.pathPatternCompile = null;
        }
        this.allowAllMethods = false;
        this.allowMethodsHash = null;
        if (this.allowMethods != null) {
            if (this.allowMethods.contains("*")) {
                this.allowAllMethods = true;
            }
            this.allowMethodsHash = new HashSet<String>(this.allowMethods);
        }
        this.allowAllContentTypes = false;
        this.allowContentTypesMT = null;
        if (this.allowContentTypes != null) {
            if (this.allowContentTypes.contains("*/*")) {
                this.allowAllContentTypes = true;
            }
            this.allowContentTypesMT = new MediaType[this.allowContentTypes.size()];
            for (int i = 0; i < this.allowContentTypesMT.length; ++i) {
                this.allowContentTypesMT[i] = MediaType.valueOf((String)this.allowContentTypes.get(i));
            }
        }
    }

    public void inited(WebFrontendService service, Config config) {
        this.init();
    }

    public long maxBodySize() {
        if (this.maxBodySize == null) {
            return -1L;
        }
        return this.maxBodySize;
    }

    public long maxFileSize() {
        if (this.maxFileSize == null) {
            return -1L;
        }
        return this.maxFileSize;
    }

    public Pattern getPathPatternCompile() {
        return this.pathPatternCompile;
    }

    public void destroyed() {
    }

    public boolean isAllowedMethod(String requestMethod) {
        if (this.allowAllMethods) {
            return true;
        }
        if (this.allowMethodsHash != null) {
            return this.allowMethodsHash.contains(requestMethod);
        }
        return false;
    }

    public boolean isAllowedContentType(String contentType) {
        if (this.allowAllContentTypes) {
            return true;
        }
        MediaType ct = MediaType.valueOf((String)contentType);
        if (ct.isWildcardType() || ct.isWildcardSubtype()) {
            return false;
        }
        if (this.allowContentTypesMT != null) {
            for (MediaType act : this.allowContentTypesMT) {
                if (!ct.isCompatible(act)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAllowedContentType(MediaType contentType) {
        if (this.allowAllContentTypes) {
            return true;
        }
        if (contentType.isWildcardType() || contentType.isWildcardSubtype()) {
            return false;
        }
        if (this.allowContentTypesMT != null) {
            for (MediaType act : this.allowContentTypesMT) {
                if (!contentType.isCompatible(act)) continue;
                return true;
            }
        }
        return false;
    }
}

