/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping;

import java.io.IOException;
import javax.servlet.ServletException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.web.WebProcessRuntimeException;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.actionmapping.Result;
import org.iplass.mtp.impl.web.template.MetaTemplate;
import org.iplass.mtp.impl.web.template.TemplateService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.actionmapping.definition.result.ContentDispositionType;
import org.iplass.mtp.web.actionmapping.definition.result.DynamicTemplateResultDefinition;
import org.iplass.mtp.web.actionmapping.definition.result.ResultDefinition;

public class DynamicTemplateResult
extends Result {
    private static final long serialVersionUID = 3667959224517917109L;
    private String templatePathAttributeName;
    private boolean useContentDisposition;
    private ContentDispositionType contentDispositionType;
    private String fileNameAttributeName;
    private String layoutActionAttributeName;

    public DynamicTemplateResult() {
    }

    public DynamicTemplateResult(String cmdStatus, String templatePathAttributeName) {
        this.setCommandResultStatus(cmdStatus);
        this.templatePathAttributeName = templatePathAttributeName;
    }

    public String getTemplatePathAttributeName() {
        return this.templatePathAttributeName;
    }

    public void setTemplatePathAttributeName(String templatePathAttributeName) {
        this.templatePathAttributeName = templatePathAttributeName;
    }

    public boolean isUseContentDisposition() {
        return this.useContentDisposition;
    }

    public void setUseContentDisposition(boolean useContentDisposition) {
        this.useContentDisposition = useContentDisposition;
    }

    public ContentDispositionType getContentDispositionType() {
        return this.contentDispositionType;
    }

    public void setContentDispositionType(ContentDispositionType contentDispositionType) {
        this.contentDispositionType = contentDispositionType;
    }

    public String getFileNameAttributeName() {
        return this.fileNameAttributeName;
    }

    public void setFileNameAttributeName(String fileNameAttributeName) {
        this.fileNameAttributeName = fileNameAttributeName;
    }

    public String getLayoutActionAttributeName() {
        return this.layoutActionAttributeName;
    }

    public void setLayoutActionAttributeName(String layoutActionAttributeName) {
        this.layoutActionAttributeName = layoutActionAttributeName;
    }

    @Override
    public DynamicTemplateResultRuntime createRuntime() {
        return new DynamicTemplateResultRuntime();
    }

    @Override
    public void applyConfig(ResultDefinition definition) {
        this.fillFrom(definition);
        DynamicTemplateResultDefinition def = (DynamicTemplateResultDefinition)definition;
        this.templatePathAttributeName = def.getTemplatePathAttributeName();
        this.useContentDisposition = def.isUseContentDisposition();
        this.contentDispositionType = def.getContentDispositionType();
        this.fileNameAttributeName = def.getFileNameAttributeName();
    }

    @Override
    public ResultDefinition currentConfig() {
        DynamicTemplateResultDefinition definition = new DynamicTemplateResultDefinition();
        this.fillTo(definition);
        definition.setTemplatePathAttributeName(this.templatePathAttributeName);
        definition.setUseContentDisposition(this.useContentDisposition);
        definition.setContentDispositionType(this.contentDispositionType);
        definition.setFileNameAttributeName(this.fileNameAttributeName);
        definition.setLayoutActionAttributeName(this.layoutActionAttributeName);
        return definition;
    }

    public class DynamicTemplateResultRuntime
    extends Result.ResultRuntime {
        public DynamicTemplateResultRuntime() {
            super(DynamicTemplateResult.this);
        }

        @Override
        public DynamicTemplateResult getMetaData() {
            return DynamicTemplateResult.this;
        }

        @Override
        public void handle(WebRequestStack requestStack) throws ServletException, IOException {
            String layoutActionName;
            RequestContext cmdRequestContext = requestStack.getRequestContext();
            String templatePath = (String)cmdRequestContext.getAttribute(DynamicTemplateResult.this.templatePathAttributeName);
            TemplateService ts = (TemplateService)ServiceRegistry.getRegistry().getService(TemplateService.class);
            MetaTemplate.TemplateRuntime tr = (MetaTemplate.TemplateRuntime)ts.getRuntimeByName(templatePath);
            if (tr == null) {
                throw new WebProcessRuntimeException(templatePath + " not found");
            }
            if (DynamicTemplateResult.this.useContentDisposition) {
                String fileName = null;
                if (StringUtil.isNotEmpty((String)DynamicTemplateResult.this.fileNameAttributeName)) {
                    fileName = (String)cmdRequestContext.getAttribute(DynamicTemplateResult.this.fileNameAttributeName);
                }
                if (fileName == null) {
                    fileName = this.getLastTemplateName(tr.getMetaData().getName());
                }
                WebUtil.setContentDispositionHeader(requestStack, DynamicTemplateResult.this.getContentDispositionType(), fileName);
            }
            if (StringUtil.isNotEmpty((String)DynamicTemplateResult.this.layoutActionAttributeName) && StringUtil.isNotEmpty((String)(layoutActionName = (String)cmdRequestContext.getAttribute(DynamicTemplateResult.this.layoutActionAttributeName)))) {
                requestStack.setAttribute("org.iplass.mtp.layoutActionName", layoutActionName);
            }
            tr.handle(requestStack);
        }

        @Override
        public void finallyProcess(WebRequestStack requestContext) {
        }

        private String getLastTemplateName(String templateName) {
            if (templateName.contains("/")) {
                return templateName.substring(templateName.lastIndexOf("/") + 1);
            }
            return templateName;
        }
    }
}

