/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping;

import java.io.IOException;
import javax.servlet.ServletException;
import org.iplass.mtp.impl.web.WebProcessRuntimeException;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingService;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.actionmapping.Result;
import org.iplass.mtp.impl.web.template.MetaTemplate;
import org.iplass.mtp.impl.web.template.TemplateService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.actionmapping.definition.result.ContentDispositionType;
import org.iplass.mtp.web.actionmapping.definition.result.ResultDefinition;
import org.iplass.mtp.web.actionmapping.definition.result.TemplateResultDefinition;

public class TemplateResult
extends Result {
    private static final long serialVersionUID = 8382753736577498165L;
    private String templateId;
    private String templateName;
    private boolean resolveByName;
    private boolean useContentDisposition;
    private ContentDispositionType contentDispositionType;
    private String fileNameAttributeName;
    private String layoutId;
    private String layoutName;
    private boolean layoutResolveByName;

    public TemplateResult() {
    }

    public TemplateResult(String cmdStatus, String templateId) {
        this(cmdStatus, false, templateId);
    }

    public TemplateResult(String cmdStatus, boolean resolveByName, String templateIdOrName) {
        this.setCommandResultStatus(cmdStatus);
        this.resolveByName = resolveByName;
        if (resolveByName) {
            this.templateName = templateIdOrName;
        } else {
            this.templateId = templateIdOrName;
        }
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public boolean isResolveByName() {
        return this.resolveByName;
    }

    public void setResolveByName(boolean resolveByName) {
        this.resolveByName = resolveByName;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public boolean isUseContentDisposition() {
        return this.useContentDisposition;
    }

    public void setUseContentDisposition(boolean useContentDisposition) {
        this.useContentDisposition = useContentDisposition;
    }

    public ContentDispositionType getContentDispositionType() {
        return this.contentDispositionType;
    }

    public void setContentDispositionType(ContentDispositionType contentDispositionType) {
        this.contentDispositionType = contentDispositionType;
    }

    public String getFileNameAttributeName() {
        return this.fileNameAttributeName;
    }

    public void setFileNameAttributeName(String fileNameAttributeName) {
        this.fileNameAttributeName = fileNameAttributeName;
    }

    public String getLayoutId() {
        return this.layoutId;
    }

    public void setLayoutId(String layoutId) {
        this.layoutId = layoutId;
    }

    public String getLayoutName() {
        return this.layoutName;
    }

    public void setLayoutName(String layoutName) {
        this.layoutName = layoutName;
    }

    public boolean isLayoutResolveByName() {
        return this.layoutResolveByName;
    }

    public void setLayoutResolveByName(boolean layoutResolveByName) {
        this.layoutResolveByName = layoutResolveByName;
    }

    @Override
    public Result.ResultRuntime createRuntime() {
        return new TemplateResultRuntime();
    }

    @Override
    public void applyConfig(ResultDefinition definition) {
        this.fillFrom(definition);
        TemplateResultDefinition def = (TemplateResultDefinition)definition;
        TemplateService ts = (TemplateService)ServiceRegistry.getRegistry().getService(TemplateService.class);
        this.templateId = ((MetaTemplate.TemplateRuntime)ts.getRuntimeByName(def.getTemplateName())).getMetaData().getId();
        this.resolveByName = false;
        this.templateName = null;
        this.useContentDisposition = def.isUseContentDisposition();
        this.contentDispositionType = def.getContentDispositionType();
        this.fileNameAttributeName = def.getFileNameAttributeName();
        if (def.getLayoutActionName() != null && !def.getLayoutActionName().isEmpty()) {
            ActionMappingService service = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class);
            MetaActionMapping.ActionMappingRuntime runtime = (MetaActionMapping.ActionMappingRuntime)service.getRuntimeByName(def.getLayoutActionName());
            this.layoutId = runtime.getMetaData().getId();
            this.layoutName = null;
            this.layoutResolveByName = false;
        }
    }

    @Override
    public ResultDefinition currentConfig() {
        MetaActionMapping.ActionMappingRuntime runtime;
        ActionMappingService service;
        MetaTemplate.TemplateRuntime t;
        TemplateResultDefinition definition = new TemplateResultDefinition();
        this.fillTo(definition);
        TemplateService ts = (TemplateService)ServiceRegistry.getRegistry().getService(TemplateService.class);
        if (this.resolveByName) {
            t = (MetaTemplate.TemplateRuntime)ts.getRuntimeByName(this.templateName);
            if (t == null) {
                t = (MetaTemplate.TemplateRuntime)ts.getRuntimeById(this.templateName);
            }
        } else {
            t = (MetaTemplate.TemplateRuntime)ts.getRuntimeById(this.templateId);
        }
        if (t != null) {
            MetaTemplate meta = t.getMetaData();
            definition.setTemplateName(meta.getName());
        }
        definition.setUseContentDisposition(this.useContentDisposition);
        definition.setContentDispositionType(this.contentDispositionType);
        definition.setFileNameAttributeName(this.fileNameAttributeName);
        if (StringUtil.isNotEmpty((String)this.layoutId)) {
            service = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class);
            MetaActionMapping.ActionMappingRuntime runtime2 = (MetaActionMapping.ActionMappingRuntime)service.getRuntimeById(this.layoutId);
            if (runtime2 != null) {
                definition.setLayoutActionName(runtime2.getMetaData().getName());
            }
        } else if (StringUtil.isNotEmpty((String)this.layoutName) && (runtime = (MetaActionMapping.ActionMappingRuntime)(service = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class)).getRuntimeByName(this.layoutName)) != null) {
            definition.setLayoutActionName(runtime.getMetaData().getName());
        }
        return definition;
    }

    public class TemplateResultRuntime
    extends Result.ResultRuntime {
        @Override
        public TemplateResult getMetaData() {
            return TemplateResult.this;
        }

        private MetaTemplate.TemplateRuntime getTemplate() {
            TemplateService ts = (TemplateService)ServiceRegistry.getRegistry().getService(TemplateService.class);
            MetaTemplate.TemplateRuntime tr = null;
            if (TemplateResult.this.resolveByName) {
                tr = (MetaTemplate.TemplateRuntime)ts.getRuntimeByName(TemplateResult.this.templateName);
                if (tr == null) {
                    tr = (MetaTemplate.TemplateRuntime)ts.getRuntimeById(TemplateResult.this.templateName);
                }
            } else {
                tr = (MetaTemplate.TemplateRuntime)ts.getRuntimeById(TemplateResult.this.templateId);
            }
            return tr;
        }

        @Override
        public void handle(WebRequestStack requestStack) throws ServletException, IOException {
            MetaTemplate.TemplateRuntime tr = this.getTemplate();
            if (tr == null) {
                if (TemplateResult.this.resolveByName) {
                    throw new WebProcessRuntimeException("can not find template... name:" + TemplateResult.this.templateName);
                }
                throw new WebProcessRuntimeException("can not find template... id:" + TemplateResult.this.templateId);
            }
            if (TemplateResult.this.useContentDisposition) {
                String fileName = null;
                if (StringUtil.isNotEmpty((String)TemplateResult.this.fileNameAttributeName)) {
                    fileName = (String)requestStack.getRequestContext().getAttribute(TemplateResult.this.fileNameAttributeName);
                }
                if (fileName == null) {
                    fileName = this.getLastTemplateName(tr.getMetaData().getName());
                }
                WebUtil.setContentDispositionHeader(requestStack, TemplateResult.this.getContentDispositionType(), fileName);
            }
            if (TemplateResult.this.layoutResolveByName && StringUtil.isNotEmpty((String)TemplateResult.this.layoutName)) {
                requestStack.setAttribute("org.iplass.mtp.layoutActionName", TemplateResult.this.layoutName);
            } else if (StringUtil.isNotEmpty((String)TemplateResult.this.layoutId)) {
                requestStack.setAttribute("org.iplass.mtp.layoutActionId", TemplateResult.this.layoutId);
            }
            tr.handle(requestStack);
        }

        public String getTemplateName() {
            MetaTemplate.TemplateRuntime tr = this.getTemplate();
            if (tr == null) {
                return null;
            }
            return tr.getMetaData().getName();
        }

        @Override
        public void finallyProcess(WebRequestStack requestContext) {
        }

        private String getLastTemplateName(String templateName) {
            if (templateName.contains("/")) {
                return templateName.substring(templateName.lastIndexOf("/") + 1);
            }
            return templateName;
        }
    }
}

