/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping;

import java.io.IOException;
import javax.servlet.ServletException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.interceptor.CommandInterceptor;
import org.iplass.mtp.impl.command.InvocationImpl;
import org.iplass.mtp.impl.command.MetaCommand;
import org.iplass.mtp.impl.web.RequestPath;
import org.iplass.mtp.impl.web.WebProcessRuntimeException;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingService;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.actionmapping.Result;
import org.iplass.mtp.impl.web.actionmapping.TemplateResult;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.web.interceptor.RequestInterceptor;
import org.iplass.mtp.web.interceptor.RequestInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebInvocationImpl
extends InvocationImpl
implements RequestInvocation {
    private static final Logger logger = LoggerFactory.getLogger(WebInvocationImpl.class);
    public static RequestInterceptor[] NULL_REQUEST_INTERCEPTOR = new RequestInterceptor[0];
    private RequestInterceptor[] requestInterceptors;
    private int reqIndex;
    private int resIndex;
    private String status;
    private Throwable exception;
    private boolean isInclude;
    private MetaActionMapping.ActionMappingRuntime action;
    private WebRequestStack requestStack;

    public WebInvocationImpl(RequestInterceptor[] requestInterceptors, CommandInterceptor[] commandInterceptors, MetaCommand.CommandRuntime cmd, RequestContext request, WebRequestStack requestStack, MetaActionMapping.ActionMappingRuntime action) {
        super(commandInterceptors, cmd, request);
        this.requestInterceptors = requestInterceptors != null ? requestInterceptors : NULL_REQUEST_INTERCEPTOR;
        this.requestStack = requestStack;
        this.isInclude = !requestStack.isClientDirectRequest();
        this.reqIndex = -1;
        this.resIndex = -1;
        this.action = action;
    }

    public MetaActionMapping.ActionMappingRuntime getAction() {
        return this.action;
    }

    public WebRequestStack getRequestStack() {
        return this.requestStack;
    }

    private void doAction() {
        this.requestStack.setAttribute("actionName", this.action.getMetaData().getName());
        if (this.getCommand() != null) {
            try {
                this.proceedCommand();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.proceedResult();
    }

    private void doResult() {
        this.requestStack.setAttribute("actionName", this.action.getMetaData().getName());
        Result.ResultRuntime result = null;
        if (this.exception == null) {
            result = this.action.getResult(this.status);
            if (logger.isDebugEnabled()) {
                if (result instanceof TemplateResult.TemplateResultRuntime) {
                    logger.debug("commandResultStatus:" + this.status + "  -> Template:" + ((TemplateResult.TemplateResultRuntime)result).getTemplateName());
                } else {
                    logger.debug("commandResultStatus:" + this.status + " -> Result:" + result.getMetaData());
                }
            }
            this.requestStack.setAttribute("executedCommand", this.getCommand());
            this.requestStack.setAttribute("commandResult", this.status);
        } else {
            result = this.action.getResult(this.exception);
            if (result == null) {
                if (this.exception instanceof RuntimeException) {
                    throw (RuntimeException)this.exception;
                }
                if (this.exception instanceof Error) {
                    throw (Error)this.exception;
                }
                throw new RuntimeException(this.exception);
            }
            if (logger.isDebugEnabled()) {
                if (result instanceof TemplateResult.TemplateResultRuntime) {
                    logger.debug("commandResultException:" + this.exception.getClass().getName() + " -> Template:" + ((TemplateResult.TemplateResultRuntime)result).getTemplateName());
                } else {
                    logger.debug("commandResultException:" + this.exception.getClass().getName() + " -> Result:" + result.getMetaData());
                }
            }
            this.requestStack.setAttribute("executedCommand", this.getCommand());
            this.requestStack.setAttribute("mtp.web.exception", this.exception);
        }
        try {
            result.handle(this.requestStack);
        }
        catch (IOException | ServletException e) {
            throw new WebProcessRuntimeException(e);
        }
        finally {
            if (result != null) {
                result.finallyProcess(this.requestStack);
            }
        }
    }

    @Override
    public void proceedRequest() {
        ++this.reqIndex;
        try {
            if (this.reqIndex == this.requestInterceptors.length) {
                this.doAction();
            } else {
                this.requestInterceptors[this.reqIndex].intercept(this);
            }
        }
        finally {
            --this.reqIndex;
        }
    }

    public String proceedCommand() {
        try {
            this.status = super.proceedCommand();
            return this.status;
        }
        catch (Throwable e) {
            this.status = null;
            this.exception = e;
            throw e;
        }
    }

    @Override
    public void proceedResult() {
        ++this.resIndex;
        try {
            if (this.resIndex == this.requestInterceptors.length) {
                this.doResult();
            } else {
                this.requestInterceptors[this.resIndex].interceptResult(this);
            }
        }
        finally {
            --this.resIndex;
        }
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public void getStatus(String status) {
        if (logger.isDebugEnabled()) {
            logger.debug("set status to " + status);
        }
        this.status = status;
    }

    @Override
    public void setException(Throwable exception) {
        if (logger.isDebugEnabled()) {
            logger.debug("set exception to " + exception);
        }
        this.exception = exception;
    }

    @Override
    public boolean isInclude() {
        return this.isInclude;
    }

    @Override
    public String getActionName() {
        return this.action.getMetaData().getName();
    }

    @Override
    public void redirectAction(String actionName, RequestContext requestContext) {
        ActionMappingService amService = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class);
        MetaActionMapping.ActionMappingRuntime am = amService.getByPathHierarchy(actionName);
        if (am != null) {
            WebRequestStack wrs = new WebRequestStack(new RequestPath(actionName, this.requestStack.getRequestPath()), requestContext, this.requestStack.getServletContext(), this.requestStack.getRequest(), this.requestStack.getResponse(), this.requestStack.getPageContext());
            try {
                am.executeCommand(wrs);
            }
            catch (IOException | ServletException e) {
                throw new WebProcessRuntimeException(e);
            }
            finally {
                if (wrs != null) {
                    wrs.finallyProcess();
                }
            }
        } else {
            throw new WebProcessRuntimeException("Can not find Action:" + actionName);
        }
    }

    @Override
    public RequestPath getRequestPath() {
        return this.requestStack.getRequestPath();
    }
}

