/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping.cache;

import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantResource;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataContextListener;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.actionmapping.cache.CachableHttpServletResponse;
import org.iplass.mtp.impl.web.actionmapping.cache.ContentCache;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaCacheCriteria;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.web.actionmapping.definition.cache.RelatedEntityType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentCacheContext
implements TenantResource {
    public static final String ACTION_CONTENT_CACHE_NAMESPACE = "mtp.action.content";
    public static final String HOLE_ENTITY = "*";
    private static Logger logger = LoggerFactory.getLogger(ContentCacheContext.class);
    private CacheStore contentCacheStore;
    private MetaDataContext metaDataContext;
    private MetaDataContextListener metaDatalistener = new MetaDataContextListener(){

        public void updated(String path, String pathBefore) {
            String entityName;
            String actionName;
            if (path.startsWith("/action/")) {
                actionName = path.substring("/action/".length());
                ContentCacheContext.this.invalidateByActionName(actionName);
            } else if (path.startsWith("/entity/")) {
                entityName = path.substring("/entity/".length()).replace('/', '.');
                ContentCacheContext.this.invalidateByEntityName(entityName);
            }
            if (pathBefore != null) {
                if (pathBefore.startsWith("/action/")) {
                    actionName = pathBefore.substring("/action/".length());
                    ContentCacheContext.this.invalidateByActionName(actionName);
                } else if (pathBefore.startsWith("/entity/")) {
                    entityName = pathBefore.substring("/entity/".length()).replace('/', '.');
                    ContentCacheContext.this.invalidateByEntityName(entityName);
                }
            }
        }

        public void removed(String path) {
            if (path.startsWith("/action/")) {
                String actionName = path.substring("/action/".length());
                ContentCacheContext.this.invalidateByActionName(actionName);
            } else if (path.startsWith("/entity/")) {
                String entityName = path.substring("/entity/".length());
                ContentCacheContext.this.invalidateByEntityName(entityName);
            }
        }

        public void created(String path) {
        }
    };

    public static final ContentCacheContext getContentCacheContext() {
        return (ContentCacheContext)ExecuteContext.getCurrentContext().getTenantContext().getResource(ContentCacheContext.class);
    }

    public void init(TenantContext tenantContext) {
        int tenantId = tenantContext.getTenantId();
        CacheService cs = (CacheService)ServiceRegistry.getRegistry().getService(CacheService.class);
        this.contentCacheStore = cs.getCache("mtp.action.content/" + tenantId);
        this.metaDataContext = tenantContext.getMetaDataContext();
        this.metaDataContext.addMetaDataContextListener(this.metaDatalistener);
    }

    public void destory() {
        CacheService cs = (CacheService)ServiceRegistry.getRegistry().getService(CacheService.class);
        cs.invalidate(this.contentCacheStore.getNamespace());
        this.metaDataContext.removeMetaDataContextListener(this.metaDatalistener);
        if (logger.isTraceEnabled()) {
            logger.trace("invalidate all action cache.");
        }
    }

    public ContentCache get(String actionName, String lang, String key) {
        String cacheKey = this.genKey(actionName, lang, key);
        CacheEntry ce = this.contentCacheStore.get((Object)cacheKey);
        if (ce != null) {
            ContentCache cc;
            if (logger.isTraceEnabled()) {
                logger.trace("hits action cache:" + cacheKey);
            }
            if ((cc = (ContentCache)ce.getValue()).getExpires() < System.currentTimeMillis()) {
                this.invalidate(cacheKey);
                return null;
            }
            return (ContentCache)ce.getValue();
        }
        return null;
    }

    public void put(String actionName, String lang, String key, ContentCache contentCache) {
        String cacheKey = this.genKey(actionName, lang, key);
        if (logger.isTraceEnabled()) {
            logger.trace("put action cache:" + cacheKey);
        }
        String[] entityNameAndOidArray = null;
        if (contentCache.getRelatedEntityNameAndOid() != null) {
            entityNameAndOidArray = contentCache.getRelatedEntityNameAndOid().toArray(new String[contentCache.getRelatedEntityNameAndOid().size()]);
        }
        String[] entityNameArray = null;
        if (contentCache.getRelatedEntityName() != null) {
            entityNameArray = contentCache.getRelatedEntityName().toArray(new String[contentCache.getRelatedEntityName().size()]);
        }
        this.contentCacheStore.put(new CacheEntry((Object)cacheKey, (Object)contentCache, contentCache.getCreationTime(), new Object[]{actionName, entityNameAndOidArray, entityNameArray}), true);
    }

    private MetaActionMapping.ActionMappingRuntime getAction(WebRequestStack stack) {
        if (stack == null) {
            return null;
        }
        MetaActionMapping.ActionMappingRuntime amr = (MetaActionMapping.ActionMappingRuntime)((Object)stack.getAttribute("org.iplass.mtp.actionRuntime"));
        if (amr == null) {
            return this.getAction(stack.getPrevStack());
        }
        return amr;
    }

    public boolean isRecordEntity(String entityName) {
        MetaCacheCriteria.CacheCriteriaRuntime ccr;
        RelatedEntityType type;
        CachableHttpServletResponse res;
        ContentCache cc;
        WebRequestStack stack = WebRequestStack.getCurrent();
        return stack != null && stack.getResponse() instanceof CachableHttpServletResponse && (cc = (res = (CachableHttpServletResponse)stack.getResponse()).getCurrentContentCache()) != null && (type = (ccr = this.getAction(stack).getCacheCriteria()).checkRelatedEntity(entityName)) != null;
    }

    public void record(String entityName, String oid, Long expires) {
        CachableHttpServletResponse res;
        ContentCache cc;
        WebRequestStack stack = WebRequestStack.getCurrent();
        if (stack != null && stack.getResponse() instanceof CachableHttpServletResponse && (cc = (res = (CachableHttpServletResponse)stack.getResponse()).getCurrentContentCache()) != null) {
            MetaCacheCriteria.CacheCriteriaRuntime ccr = this.getAction(stack).getCacheCriteria();
            RelatedEntityType type = ccr.checkRelatedEntity(entityName);
            if (type != null) {
                if (type == RelatedEntityType.WHOLE) {
                    cc.addRelatedEntity(entityName, HOLE_ENTITY);
                } else if (!HOLE_ENTITY.equals(oid)) {
                    cc.addRelatedEntity(entityName, oid);
                }
            }
            if (expires != null && cc.getExpires() > expires) {
                cc.setExpires(expires);
            }
        }
    }

    public void recordForce(RelatedEntityType type, String entityName, String oid) {
        CachableHttpServletResponse res;
        ContentCache cc;
        WebRequestStack stack = WebRequestStack.getCurrent();
        if (stack != null && stack.getResponse() instanceof CachableHttpServletResponse && (cc = (res = (CachableHttpServletResponse)stack.getResponse()).getCurrentContentCache()) != null) {
            if (type == RelatedEntityType.WHOLE) {
                cc.addRelatedEntity(entityName, HOLE_ENTITY);
            } else if (type == RelatedEntityType.SPECIFIC_ID && oid != null) {
                cc.addRelatedEntity(entityName, oid);
            }
        }
    }

    public void setCacheExpires(long expires) {
        CachableHttpServletResponse res;
        ContentCache cc;
        WebRequestStack stack = WebRequestStack.getCurrent();
        if (stack != null && stack.getResponse() instanceof CachableHttpServletResponse && (cc = (res = (CachableHttpServletResponse)stack.getResponse()).getCurrentContentCache()) != null && cc.getExpires() > expires) {
            cc.setExpires(expires);
        }
    }

    private String genKey(String actionName, String lang, String key) {
        return actionName + ";" + lang + ";" + key;
    }

    public void invalidate(String actionName, String lang, String key) {
        this.invalidate(this.genKey(actionName, lang, key));
    }

    private void invalidate(String cacheKey) {
        this.contentCacheStore.remove((Object)cacheKey);
        if (logger.isTraceEnabled()) {
            logger.trace("invalidate action cache:" + cacheKey);
        }
    }

    public void invalidateByActionName(String actionName) {
        this.contentCacheStore.removeByIndex(0, (Object)actionName);
        if (logger.isTraceEnabled()) {
            logger.trace("invalidate action cache:" + actionName);
        }
    }

    public void invalidateByEntityName(String entityName) {
        this.contentCacheStore.removeByIndex(2, (Object)entityName);
        if (logger.isTraceEnabled()) {
            logger.trace("invalidate action cache by entityName:" + entityName);
        }
    }

    public void invalidateByEntityNameAndOid(String entityName, String oid) {
        this.contentCacheStore.removeByIndex(1, (Object)(entityName + ";" + oid));
        if (logger.isTraceEnabled()) {
            logger.trace("invalidate action cache by entityName:" + entityName + ";" + oid);
        }
    }

    public void invalidateAllEntry() {
        this.contentCacheStore.removeAll();
        if (logger.isTraceEnabled()) {
            logger.trace("invalidate all action cache.");
        }
    }
}

