/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaCacheCriteria;
import org.iplass.mtp.web.actionmapping.definition.cache.CacheCriteriaDefinition;
import org.iplass.mtp.web.actionmapping.definition.cache.ParameterMatchCacheCriteriaDefinition;

public class MetaParameterMatchCacheCriteria
extends MetaCacheCriteria {
    private static final long serialVersionUID = -620353212482061976L;
    private List<String> matchingParameterName;

    public List<String> getMatchingParameterName() {
        return this.matchingParameterName;
    }

    public void setMatchingParameterName(List<String> matchingParameterName) {
        this.matchingParameterName = matchingParameterName;
    }

    @Override
    public void applyConfig(CacheCriteriaDefinition definition) {
        this.fillFrom(definition);
        ParameterMatchCacheCriteriaDefinition def = (ParameterMatchCacheCriteriaDefinition)definition;
        if (def.getMatchingParameterName() != null) {
            this.matchingParameterName = new ArrayList<String>();
            this.matchingParameterName.addAll(def.getMatchingParameterName());
        } else {
            this.matchingParameterName = null;
        }
    }

    @Override
    public CacheCriteriaDefinition currentConfig() {
        ParameterMatchCacheCriteriaDefinition definition = new ParameterMatchCacheCriteriaDefinition();
        this.fillTo(definition);
        if (this.matchingParameterName != null) {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(this.matchingParameterName);
            definition.setMatchingParameterName(names);
        }
        return definition;
    }

    @Override
    public ParameterMatchCacheCriteriaRuntime createRuntime(MetaActionMapping actionMapping) {
        return new ParameterMatchCacheCriteriaRuntime();
    }

    public class ParameterMatchCacheCriteriaRuntime
    extends MetaCacheCriteria.CacheCriteriaRuntime {
        private List<String> sortedParamList;

        public ParameterMatchCacheCriteriaRuntime() {
            if (MetaParameterMatchCacheCriteria.this.matchingParameterName != null) {
                this.sortedParamList = new ArrayList<String>(MetaParameterMatchCacheCriteria.this.matchingParameterName);
                Collections.sort(this.sortedParamList);
            } else {
                this.sortedParamList = Collections.emptyList();
            }
        }

        @Override
        public String createContentCacheKey(RequestContext request) {
            StringBuilder sb = new StringBuilder();
            for (String param : this.sortedParamList) {
                sb.append(param);
                sb.append("=");
                String[] value = request.getParams(param);
                if (value != null && value.length > 0) {
                    if (value.length == 1) {
                        sb.append(value[0]);
                    } else {
                        Object[] copy = new String[value.length];
                        System.arraycopy(value, 0, copy, 0, copy.length);
                        Arrays.sort(copy);
                        for (Object v : copy) {
                            sb.append((String)v);
                            sb.append(":");
                        }
                    }
                }
                sb.append(",");
            }
            return sb.toString();
        }
    }
}

