/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.interceptors;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.logstash.logback.argument.StructuredArguments;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.rdb.connection.ConnectionFactory;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingService;
import org.iplass.mtp.impl.web.interceptors.ExceptionInterceptor;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.web.interceptor.RequestInterceptor;
import org.iplass.mtp.web.interceptor.RequestInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LoggingInterceptor
implements RequestInterceptor,
ServiceInitListener<ActionMappingService> {
    private static final String MDC_ACTION = "action";
    private static Logger actionLogger = LoggerFactory.getLogger((String)"mtp.action");
    private static Logger partsLogger = LoggerFactory.getLogger((String)"mtp.action.parts");
    private boolean actionTrace = true;
    private boolean partsTrace = true;
    private int warnLogThresholdOfSqlExecutionCount = -1;
    private long warnLogThresholdOfExecutionTimeMillis = -1L;
    private ConnectionFactory rdbConFactory;
    private String[] paramName;
    private List<String> noStackTrace;
    private List<Class<?>[]> noStackTraceClass;

    public void inited(ActionMappingService service, Config config) {
        if (this.noStackTrace != null) {
            this.noStackTraceClass = ExceptionInterceptor.toClassList(this.noStackTrace);
        }
        this.rdbConFactory = (ConnectionFactory)ServiceRegistry.getRegistry().getService(ConnectionFactory.class);
    }

    public void destroyed() {
    }

    public List<String> getNoStackTrace() {
        return this.noStackTrace;
    }

    public void setNoStackTrace(List<String> noStackTrace) {
        this.noStackTrace = noStackTrace;
    }

    public String[] getParamName() {
        return this.paramName;
    }

    public void setParamName(String[] paramName) {
        this.paramName = paramName;
    }

    public boolean isPartsTrace() {
        return this.partsTrace;
    }

    public void setPartsTrace(boolean partsTrace) {
        this.partsTrace = partsTrace;
    }

    public int getWarnLogThresholdOfSqlExecutionCount() {
        return this.warnLogThresholdOfSqlExecutionCount;
    }

    public void setWarnLogThresholdOfSqlExecutionCount(int warnLogThresholdOfSqlExecutionCount) {
        this.warnLogThresholdOfSqlExecutionCount = warnLogThresholdOfSqlExecutionCount;
    }

    public long getWarnLogThresholdOfExecutionTimeMillis() {
        return this.warnLogThresholdOfExecutionTimeMillis;
    }

    public void setWarnLogThresholdOfExecutionTimeMillis(long warnLogThresholdOfExecutionTimeMillis) {
        this.warnLogThresholdOfExecutionTimeMillis = warnLogThresholdOfExecutionTimeMillis;
    }

    @Override
    public void intercept(RequestInvocation invocation) {
        long executionTime;
        long start = -1L;
        if (this.actionTrace) {
            start = System.currentTimeMillis();
        }
        String prev = MDC.get((String)MDC_ACTION);
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        ec.mdcPut(MDC_ACTION, invocation.getActionName());
        Throwable exp = null;
        AtomicInteger sqlCounter = this.rdbConFactory.getCounterOfSqlExecution();
        try {
            invocation.proceedRequest();
            exp = (Throwable)invocation.getRequest().getAttribute("mtp.web.exception");
            executionTime = start == -1L ? start : System.currentTimeMillis() - start;
        }
        catch (RuntimeException t) {
            try {
                exp = t;
                throw t;
            }
            catch (Throwable throwable) {
                long executionTime2 = start == -1L ? start : System.currentTimeMillis() - start;
                int sqlCount = sqlCounter == null ? -1 : sqlCounter.get();
                MessagePattern mp = MessagePattern.getInstance(executionTime2, sqlCount, exp);
                if (exp != null && !(exp instanceof ApplicationException)) {
                    Logger log = null;
                    log = invocation.isInclude() ? partsLogger : actionLogger;
                    log.error(mp.format(), mp.arguments(this.getRequestPathAndParam(invocation), executionTime2, sqlCount, exp, !ExceptionInterceptor.match(this.noStackTraceClass, exp)));
                } else if (this.actionTrace && !invocation.isInclude()) {
                    if (this.isWarnLog(executionTime2, sqlCount)) {
                        actionLogger.warn(mp.format(), mp.arguments(this.getRequestPathAndParam(invocation), executionTime2, sqlCount, exp, actionLogger.isDebugEnabled()));
                    } else {
                        actionLogger.info(mp.format(), mp.arguments(this.getRequestPathAndParam(invocation), executionTime2, sqlCount, exp, actionLogger.isDebugEnabled()));
                    }
                } else if (this.partsTrace && invocation.isInclude() && partsLogger.isDebugEnabled()) {
                    partsLogger.debug(mp.format(), mp.arguments(this.getRequestPathAndParam(invocation), executionTime2, sqlCount, exp, false));
                }
                if (prev == null) {
                    MDC.remove((String)MDC_ACTION);
                } else {
                    ec.mdcPut(MDC_ACTION, prev);
                }
                throw throwable;
            }
        }
        int sqlCount = sqlCounter == null ? -1 : sqlCounter.get();
        MessagePattern mp = MessagePattern.getInstance(executionTime, sqlCount, exp);
        if (exp != null && !(exp instanceof ApplicationException)) {
            Logger log = null;
            log = invocation.isInclude() ? partsLogger : actionLogger;
            log.error(mp.format(), mp.arguments(this.getRequestPathAndParam(invocation), executionTime, sqlCount, exp, !ExceptionInterceptor.match(this.noStackTraceClass, exp)));
        } else if (this.actionTrace && !invocation.isInclude()) {
            if (this.isWarnLog(executionTime, sqlCount)) {
                actionLogger.warn(mp.format(), mp.arguments(this.getRequestPathAndParam(invocation), executionTime, sqlCount, exp, actionLogger.isDebugEnabled()));
            } else {
                actionLogger.info(mp.format(), mp.arguments(this.getRequestPathAndParam(invocation), executionTime, sqlCount, exp, actionLogger.isDebugEnabled()));
            }
        } else if (this.partsTrace && invocation.isInclude() && partsLogger.isDebugEnabled()) {
            partsLogger.debug(mp.format(), mp.arguments(this.getRequestPathAndParam(invocation), executionTime, sqlCount, exp, false));
        }
        if (prev == null) {
            MDC.remove((String)MDC_ACTION);
        } else {
            ec.mdcPut(MDC_ACTION, prev);
        }
    }

    private boolean isWarnLog(long executionTime, int sqlCount) {
        if (this.warnLogThresholdOfSqlExecutionCount >= 0 && sqlCount > this.warnLogThresholdOfSqlExecutionCount) {
            return true;
        }
        return this.warnLogThresholdOfExecutionTimeMillis >= 0L && executionTime > this.warnLogThresholdOfExecutionTimeMillis;
    }

    private CharSequence getRequestPathAndParam(RequestInvocation invocation) {
        if (invocation.isInclude()) {
            return invocation.getActionName();
        }
        String actionName = invocation.getRequestPath().getTargetPath(true);
        if (this.paramName == null) {
            return actionName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(actionName);
        boolean isFirst = true;
        for (String p : this.paramName) {
            String val = invocation.getRequest().getParam(p);
            if (val == null) continue;
            if (isFirst) {
                sb.append("?");
                isFirst = false;
            } else {
                sb.append("&");
            }
            if (val instanceof String[]) {
                String[] valArray = (String[])val;
                for (int i = 0; i < valArray.length; ++i) {
                    if (i != 0) {
                        sb.append("&");
                    }
                    sb.append(p).append("=").append(valArray[i]);
                }
                continue;
            }
            sb.append(p).append("=").append((Object)val);
        }
        return sb;
    }

    public static enum MessagePattern {
        ALL("{},{}ms,{}times(sql),{},{}"){

            @Override
            public Object[] arguments(CharSequence requestPath, long executionTime, int sqlCount, Throwable exp, boolean withStackTrace) {
                Object[] args;
                if (withStackTrace) {
                    args = new Object[6];
                    args[5] = exp;
                } else {
                    args = new Object[]{StructuredArguments.value((String)MessagePattern.ARG_REQUEST_PATH, (Object)requestPath), StructuredArguments.value((String)MessagePattern.ARG_EXECUTION_TIME, (Object)executionTime), StructuredArguments.value((String)MessagePattern.ARG_SQL_EXECUTION_COUNT, (Object)sqlCount), exp instanceof ApplicationException ? StructuredArguments.value((String)MessagePattern.ARG_ERROR_TYPE, (Object)MessagePattern.TYPE_APP_ERROR) : StructuredArguments.value((String)MessagePattern.ARG_ERROR_TYPE, (Object)MessagePattern.TYPE_ERROR), StructuredArguments.value((String)MessagePattern.ARG_ERROR_DESCRIPTION, (Object)exp.toString())};
                }
                return args;
            }
        }
        ,
        WITHOUT_EXP("{},{}ms,{}times(sql)"){

            @Override
            public Object[] arguments(CharSequence requestPath, long executionTime, int sqlCount, Throwable exp, boolean withStackTrace) {
                Object[] args = new Object[]{StructuredArguments.value((String)MessagePattern.ARG_REQUEST_PATH, (Object)requestPath), StructuredArguments.value((String)MessagePattern.ARG_EXECUTION_TIME, (Object)executionTime), StructuredArguments.value((String)MessagePattern.ARG_SQL_EXECUTION_COUNT, (Object)sqlCount)};
                return args;
            }
        }
        ,
        WITHOUT_EXP_SQL("{},{}ms"){

            @Override
            public Object[] arguments(CharSequence requestPath, long executionTime, int sqlCount, Throwable exp, boolean withStackTrace) {
                Object[] args = new Object[]{StructuredArguments.value((String)MessagePattern.ARG_REQUEST_PATH, (Object)requestPath), StructuredArguments.value((String)MessagePattern.ARG_EXECUTION_TIME, (Object)executionTime)};
                return args;
            }
        }
        ,
        WITHOUT_EXP_TIME("{},{}times(sql)"){

            @Override
            public Object[] arguments(CharSequence requestPath, long executionTime, int sqlCount, Throwable exp, boolean withStackTrace) {
                Object[] args = new Object[]{StructuredArguments.value((String)MessagePattern.ARG_REQUEST_PATH, (Object)requestPath), StructuredArguments.value((String)MessagePattern.ARG_SQL_EXECUTION_COUNT, (Object)sqlCount)};
                return args;
            }
        }
        ,
        WITHOUT_SQL("{},{}ms,{},{}"){

            @Override
            public Object[] arguments(CharSequence requestPath, long executionTime, int sqlCount, Throwable exp, boolean withStackTrace) {
                Object[] args;
                if (withStackTrace) {
                    args = new Object[5];
                    args[4] = exp;
                } else {
                    args = new Object[]{StructuredArguments.value((String)MessagePattern.ARG_REQUEST_PATH, (Object)requestPath), StructuredArguments.value((String)MessagePattern.ARG_EXECUTION_TIME, (Object)executionTime), exp instanceof ApplicationException ? StructuredArguments.value((String)MessagePattern.ARG_ERROR_TYPE, (Object)MessagePattern.TYPE_APP_ERROR) : StructuredArguments.value((String)MessagePattern.ARG_ERROR_TYPE, (Object)MessagePattern.TYPE_ERROR), StructuredArguments.value((String)MessagePattern.ARG_ERROR_DESCRIPTION, (Object)exp.toString())};
                }
                return args;
            }
        }
        ,
        WITHOUT_TIME("{},{}times(sql),{},{}"){

            @Override
            public Object[] arguments(CharSequence requestPath, long executionTime, int sqlCount, Throwable exp, boolean withStackTrace) {
                Object[] args;
                if (withStackTrace) {
                    args = new Object[5];
                    args[4] = exp;
                } else {
                    args = new Object[]{StructuredArguments.value((String)MessagePattern.ARG_REQUEST_PATH, (Object)requestPath), StructuredArguments.value((String)MessagePattern.ARG_SQL_EXECUTION_COUNT, (Object)sqlCount), exp instanceof ApplicationException ? StructuredArguments.value((String)MessagePattern.ARG_ERROR_TYPE, (Object)MessagePattern.TYPE_APP_ERROR) : StructuredArguments.value((String)MessagePattern.ARG_ERROR_TYPE, (Object)MessagePattern.TYPE_ERROR), StructuredArguments.value((String)MessagePattern.ARG_ERROR_DESCRIPTION, (Object)exp.toString())};
                }
                return args;
            }
        }
        ,
        WITHOUT_TIME_SQL("{},{},{}"){

            @Override
            public Object[] arguments(CharSequence requestPath, long executionTime, int sqlCount, Throwable exp, boolean withStackTrace) {
                Object[] args;
                if (withStackTrace) {
                    args = new Object[4];
                    args[3] = exp;
                } else {
                    args = new Object[]{StructuredArguments.value((String)MessagePattern.ARG_REQUEST_PATH, (Object)requestPath), exp instanceof ApplicationException ? StructuredArguments.value((String)MessagePattern.ARG_ERROR_TYPE, (Object)MessagePattern.TYPE_APP_ERROR) : StructuredArguments.value((String)MessagePattern.ARG_ERROR_TYPE, (Object)MessagePattern.TYPE_ERROR), StructuredArguments.value((String)MessagePattern.ARG_ERROR_DESCRIPTION, (Object)exp.toString())};
                }
                return args;
            }
        }
        ,
        WITHOUT_ALL("{}"){

            @Override
            public Object[] arguments(CharSequence requestPath, long executionTime, int sqlCount, Throwable exp, boolean withStackTrace) {
                Object[] args = new Object[]{StructuredArguments.value((String)MessagePattern.ARG_REQUEST_PATH, (Object)requestPath)};
                return args;
            }
        };

        private static final String TYPE_APP_ERROR = "AppError";
        private static final String TYPE_ERROR = "Error";
        private static final String ARG_REQUEST_PATH = "request_path";
        private static final String ARG_EXECUTION_TIME = "execution_time";
        private static final String ARG_SQL_EXECUTION_COUNT = "sql_execution_count";
        private static final String ARG_ERROR_TYPE = "error_type";
        private static final String ARG_ERROR_DESCRIPTION = "error_description";
        private String format;

        public static MessagePattern getInstance(long executionTime, int sqlCount, Throwable exp) {
            if (exp == null) {
                if (executionTime < 0L) {
                    if (sqlCount < 0) {
                        return WITHOUT_ALL;
                    }
                    return WITHOUT_EXP_TIME;
                }
                if (sqlCount < 0) {
                    return WITHOUT_EXP_SQL;
                }
                return WITHOUT_EXP;
            }
            if (executionTime < 0L) {
                if (sqlCount < 0) {
                    return WITHOUT_TIME_SQL;
                }
                return WITHOUT_TIME;
            }
            if (sqlCount < 0) {
                return WITHOUT_SQL;
            }
            return ALL;
        }

        private MessagePattern(String format) {
            this.format = format;
        }

        public String format() {
            return this.format;
        }

        public abstract Object[] arguments(CharSequence var1, long var2, int var4, Throwable var5, boolean var6);
    }
}

