/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.template.MetaTemplate;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.definition.HtmlTemplateDefinition;
import org.iplass.mtp.web.template.definition.TemplateDefinition;

public class MetaHtmlTemplate
extends MetaTemplate {
    private static final long serialVersionUID = 4007608678165728446L;
    private String source;
    private List<MetaLocalizedString> localizedSourceList = new ArrayList<MetaLocalizedString>();

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public List<MetaLocalizedString> getLocalizedSourceList() {
        return this.localizedSourceList;
    }

    public void setLocalizedSourceList(List<MetaLocalizedString> localizedSourceList) {
        this.localizedSourceList = localizedSourceList;
    }

    @Override
    public HtmlTemplateRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new HtmlTemplateRuntime();
    }

    @Override
    public void applyConfig(TemplateDefinition definition) {
        this.fillFrom(definition);
        HtmlTemplateDefinition def = (HtmlTemplateDefinition)definition;
        this.source = def.getSource();
        this.localizedSourceList = I18nUtil.toMeta(def.getLocalizedSourceList());
    }

    @Override
    public HtmlTemplateDefinition currentConfig() {
        HtmlTemplateDefinition definition = new HtmlTemplateDefinition();
        this.fillTo(definition);
        definition.setSource(this.source);
        definition.setLocalizedSourceList(I18nUtil.toDef(this.localizedSourceList));
        return definition;
    }

    public class HtmlTemplateRuntime
    extends MetaTemplate.TemplateRuntime {
        public HtmlTemplateRuntime() {
            super(MetaHtmlTemplate.this);
        }

        @Override
        public MetaHtmlTemplate getMetaData() {
            return MetaHtmlTemplate.this;
        }

        @Override
        public void handleContent(WebRequestStack requestContext) throws IOException, ServletException {
            this.checkState();
            String lang = ExecuteContext.getCurrentContext().getLanguage();
            String tempSource = MetaHtmlTemplate.this.source;
            if (MetaHtmlTemplate.this.localizedSourceList != null) {
                for (MetaLocalizedString mls : MetaHtmlTemplate.this.localizedSourceList) {
                    if (!mls.getLocaleName().equals(lang) || !StringUtil.isNotEmpty((String)mls.getStringValue())) continue;
                    tempSource = mls.getStringValue();
                }
            }
            if (requestContext.getPageContext() != null) {
                requestContext.getPageContext().getOut().write(tempSource);
            } else {
                requestContext.getResponse().getWriter().write(tempSource);
            }
        }
    }
}

