/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletException;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingService;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.template.MetaBinaryTemplate;
import org.iplass.mtp.impl.web.template.MetaGroovyTemplate;
import org.iplass.mtp.impl.web.template.MetaHtmlTemplate;
import org.iplass.mtp.impl.web.template.MetaJspTemplate;
import org.iplass.mtp.impl.web.template.report.MetaReportTemplate;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.definition.BinaryTemplateDefinition;
import org.iplass.mtp.web.template.definition.GroovyTemplateDefinition;
import org.iplass.mtp.web.template.definition.HtmlTemplateDefinition;
import org.iplass.mtp.web.template.definition.JspTemplateDefinition;
import org.iplass.mtp.web.template.definition.TemplateDefinition;
import org.iplass.mtp.web.template.report.definition.ReportTemplateDefinition;

@XmlSeeAlso(value={MetaGroovyTemplate.class, MetaHtmlTemplate.class, MetaJspTemplate.class, MetaBinaryTemplate.class, MetaReportTemplate.class})
public abstract class MetaTemplate
extends BaseRootMetaData
implements DefinableMetaData<TemplateDefinition> {
    public static final String CONTENT_TEMPLATE = "org.iplass.mtp.contentTemplate";
    public static final String LAYOUT_ACTION_ID = "org.iplass.mtp.layoutActionId";
    public static final String LAYOUT_ACTION_NAME = "org.iplass.mtp.layoutActionName";
    private static final long serialVersionUID = -3123289156066341158L;
    private String contentType;
    private String layoutId;
    private String layoutName;
    private boolean layoutResolveByName;

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getLayoutId() {
        return this.layoutId;
    }

    public void setLayoutId(String layoutId) {
        this.layoutId = layoutId;
    }

    public String getLayoutName() {
        return this.layoutName;
    }

    public void setLayoutName(String layoutName) {
        this.layoutName = layoutName;
    }

    public boolean isLayoutResolveByName() {
        return this.layoutResolveByName;
    }

    public void setLayoutResolveByName(boolean layoutResolveByName) {
        this.layoutResolveByName = layoutResolveByName;
    }

    public MetaTemplate copy() {
        return (MetaTemplate)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public static MetaTemplate createInstance(TemplateDefinition definition) {
        if (definition instanceof GroovyTemplateDefinition) {
            return new MetaGroovyTemplate();
        }
        if (definition instanceof HtmlTemplateDefinition) {
            return new MetaHtmlTemplate();
        }
        if (definition instanceof JspTemplateDefinition) {
            return new MetaJspTemplate();
        }
        if (definition instanceof BinaryTemplateDefinition) {
            return new MetaBinaryTemplate();
        }
        if (definition instanceof ReportTemplateDefinition) {
            return new MetaReportTemplate();
        }
        return null;
    }

    public abstract void applyConfig(TemplateDefinition var1);

    public abstract TemplateDefinition currentConfig();

    protected void fillFrom(TemplateDefinition definition) {
        this.name = definition.getName();
        this.displayName = definition.getDisplayName();
        this.localizedDisplayNameList = I18nUtil.toMeta(definition.getLocalizedDisplayNameList());
        this.description = definition.getDescription();
        this.contentType = definition.getContentType();
        if (definition.getLayoutActionName() != null && !definition.getLayoutActionName().isEmpty()) {
            ActionMappingService service = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class);
            MetaActionMapping.ActionMappingRuntime runtime = (MetaActionMapping.ActionMappingRuntime)service.getRuntimeByName(definition.getLayoutActionName());
            this.layoutId = runtime.getMetaData().getId();
            this.layoutName = null;
            this.layoutResolveByName = false;
        }
    }

    protected void fillTo(TemplateDefinition definition) {
        ActionMappingService service;
        MetaActionMapping.ActionMappingRuntime runtime;
        definition.setName(this.name);
        definition.setDisplayName(this.displayName);
        definition.setLocalizedDisplayNameList(I18nUtil.toDef((List)this.localizedDisplayNameList));
        definition.setDescription(this.description);
        definition.setContentType(this.contentType);
        if (StringUtil.isNotEmpty((String)this.layoutId)) {
            ActionMappingService service2 = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class);
            MetaActionMapping.ActionMappingRuntime runtime2 = (MetaActionMapping.ActionMappingRuntime)service2.getRuntimeById(this.layoutId);
            if (runtime2 != null) {
                definition.setLayoutActionName(runtime2.getMetaData().getName());
            }
        } else if (StringUtil.isNotEmpty((String)this.layoutName) && (runtime = (MetaActionMapping.ActionMappingRuntime)(service = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class)).getRuntimeByName(this.layoutName)) != null) {
            definition.setLayoutActionName(runtime.getMetaData().getName());
        }
    }

    public abstract TemplateRuntime createRuntime(MetaDataConfig var1);

    public abstract class TemplateRuntime
    extends BaseMetaDataRuntime {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(WebRequestStack requestStack) throws IOException, ServletException {
            ActionMappingService ams;
            this.checkState();
            MetaActionMapping.ActionMappingRuntime layout = null;
            String resultLayoutActionName = (String)requestStack.getAttribute(MetaTemplate.LAYOUT_ACTION_NAME);
            String resultLayoutActionId = (String)requestStack.getAttribute(MetaTemplate.LAYOUT_ACTION_ID);
            if (resultLayoutActionName != null || MetaTemplate.this.layoutResolveByName && StringUtil.isNotEmpty((String)MetaTemplate.this.layoutName)) {
                String executeLayoutActionName;
                ams = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class);
                layout = (MetaActionMapping.ActionMappingRuntime)ams.getRuntimeByName(executeLayoutActionName = resultLayoutActionName != null ? resultLayoutActionName : MetaTemplate.this.layoutName);
                if (layout == null) {
                    layout = (MetaActionMapping.ActionMappingRuntime)ams.getRuntimeById(executeLayoutActionName);
                }
            } else if (resultLayoutActionId != null || StringUtil.isNotEmpty((String)MetaTemplate.this.layoutId)) {
                ams = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class);
                String executeLayoutActionId = resultLayoutActionId != null ? resultLayoutActionId : MetaTemplate.this.layoutId;
                layout = (MetaActionMapping.ActionMappingRuntime)ams.getRuntimeById(executeLayoutActionId);
            }
            if (layout != null) {
                WebRequestStack newStack = null;
                try {
                    newStack = new WebRequestStack();
                    newStack.setLayoutStack(true);
                    newStack.setAttribute(MetaTemplate.CONTENT_TEMPLATE, (Object)this);
                    layout.executeCommand(newStack);
                }
                finally {
                    if (newStack != null) {
                        newStack.finallyProcess();
                    }
                }
            } else {
                if (requestStack.getResponse().getContentType() == null && MetaTemplate.this.getContentType() != null) {
                    requestStack.getResponse().setContentType(MetaTemplate.this.getContentType());
                }
                this.handleContent(requestStack);
            }
        }

        public abstract void handleContent(WebRequestStack var1) throws IOException, ServletException;

        public abstract MetaTemplate getMetaData();
    }
}

