/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.token;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.token.LRUTokenStore;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;

public class TokenStore
implements Serializable {
    private static final long serialVersionUID = -7232300170363200575L;
    private static final String TOKEN_STORE_NAME = "org.iplass.mtp.tokenStore";
    public static final String TOKEN_PARAM_NAME = "_t";
    public static final String TOKEN_HEADER_NAME = "X-Transaction-Token";
    private final String fixedToken;
    private final LinkedList<String> list = new LinkedList();
    private final int maxSize;

    public static TokenStore getTokenStore(SessionContext session) {
        if (session == null) {
            return null;
        }
        return (TokenStore)session.getAttribute(TOKEN_STORE_NAME);
    }

    public static String createNewToken(SessionContext session) {
        TokenStore tokenStore = (TokenStore)session.getAttribute(TOKEN_STORE_NAME);
        if (tokenStore == null) {
            int maxSize = ((WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class)).getTransactionTokenMaxSize();
            tokenStore = new LRUTokenStore(maxSize);
        }
        String token = tokenStore.createToken();
        session.setAttribute(TOKEN_STORE_NAME, (Object)tokenStore);
        return token;
    }

    public static String getFixedToken(SessionContext session) {
        TokenStore tokenStore = (TokenStore)session.getAttribute(TOKEN_STORE_NAME);
        if (tokenStore == null) {
            int maxSize = ((WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class)).getTransactionTokenMaxSize();
            tokenStore = new LRUTokenStore(maxSize);
            session.setAttribute(TOKEN_STORE_NAME, (Object)tokenStore);
        }
        return tokenStore.getFixedToken();
    }

    public TokenStore() {
        this(((WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class)).getTransactionTokenMaxSize());
    }

    public TokenStore(int maxSize) {
        this.maxSize = maxSize;
        this.fixedToken = StringUtil.randomToken();
    }

    String getFixedToken() {
        return this.fixedToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String createToken() {
        String token = StringUtil.randomToken();
        TokenStore tokenStore = this;
        synchronized (tokenStore) {
            this.list.addFirst(token);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushBack(String token) {
        if (!token.equals(this.fixedToken)) {
            TokenStore tokenStore = this;
            synchronized (tokenStore) {
                this.list.addFirst(token);
            }
        }
    }

    public boolean isValidFixed(String token) {
        return this.fixedToken.equals(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(String token, boolean withConsume) {
        TokenStore tokenStore = this;
        synchronized (tokenStore) {
            boolean isValid = false;
            if (this.fixedToken.equals(token)) {
                return true;
            }
            ListIterator it = this.list.listIterator();
            while (it.hasNext()) {
                if (!((String)it.next()).equals(token)) continue;
                isValid = true;
                it.remove();
                break;
            }
            if (isValid && !withConsume && this.list.size() <= this.maxSize) {
                this.list.addFirst(token);
            }
            return isValid;
        }
    }
}

