/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.interceptors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.command.interceptor.CommandInvocation;
import org.iplass.mtp.impl.command.InterceptorService;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.rdb.connection.ConnectionFactory;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.interceptors.ExceptionInterceptor;
import org.iplass.mtp.impl.web.interceptors.LoggingInterceptor;
import org.iplass.mtp.impl.webapi.rest.RestRequestContext;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LoggingInterceptor
extends org.iplass.mtp.impl.command.interceptors.LoggingInterceptor
implements ServiceInitListener<InterceptorService> {
    private static Logger webapiLogger = LoggerFactory.getLogger((String)"mtp.webapi");
    private static final String MDC_WEBAPI = "webapi";
    private boolean webapiTrace = true;
    private int warnLogThresholdOfSqlExecutionCount = -1;
    private long warnLogThresholdOfExecutionTimeMillis = -1L;
    private ConnectionFactory rdbConFactory;
    private List<String> noStackTrace;
    private List<Class<?>[]> noStackTraceClass;
    private List<String> logParamName;
    private List<String> logAttributeName;

    public List<String> getLogParamName() {
        return this.logParamName;
    }

    public void setLogParamName(List<String> logParamName) {
        this.logParamName = logParamName;
    }

    public List<String> getLogAttributeName() {
        return this.logAttributeName;
    }

    public void setLogAttributeName(List<String> logAttributeName) {
        this.logAttributeName = logAttributeName;
    }

    public boolean isWebapiTrace() {
        return this.webapiTrace;
    }

    public void setWebapiTrace(boolean webapiTrace) {
        this.webapiTrace = webapiTrace;
    }

    public List<String> getNoStackTrace() {
        return this.noStackTrace;
    }

    public void setNoStackTrace(List<String> noStackTrace) {
        this.noStackTrace = noStackTrace;
    }

    public int getWarnLogThresholdOfSqlExecutionCount() {
        return this.warnLogThresholdOfSqlExecutionCount;
    }

    public void setWarnLogThresholdOfSqlExecutionCount(int warnLogThresholdOfSqlExecutionCount) {
        this.warnLogThresholdOfSqlExecutionCount = warnLogThresholdOfSqlExecutionCount;
    }

    public long getWarnLogThresholdOfExecutionTimeMillis() {
        return this.warnLogThresholdOfExecutionTimeMillis;
    }

    public void setWarnLogThresholdOfExecutionTimeMillis(long warnLogThresholdOfExecutionTimeMillis) {
        this.warnLogThresholdOfExecutionTimeMillis = warnLogThresholdOfExecutionTimeMillis;
    }

    public void inited(InterceptorService service, Config config) {
        if (this.noStackTrace != null) {
            this.noStackTraceClass = ExceptionInterceptor.toClassList(this.noStackTrace);
        }
        this.rdbConFactory = (ConnectionFactory)ServiceRegistry.getRegistry().getService(ConnectionFactory.class);
    }

    public void destroyed() {
    }

    public String intercept(CommandInvocation invocation) {
        long executionTime;
        String string;
        long start = -1L;
        if (this.webapiTrace) {
            start = System.currentTimeMillis();
        }
        String webApiName = (String)invocation.getRequest().getAttribute("webApiName");
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        ec.mdcPut(MDC_WEBAPI, webApiName);
        RuntimeException exp = null;
        AtomicInteger sqlCounter = this.rdbConFactory.getCounterOfSqlExecution();
        try {
            string = super.intercept(invocation);
            executionTime = start == -1L ? start : System.currentTimeMillis() - start;
        }
        catch (RuntimeException t) {
            try {
                exp = t;
                throw t;
            }
            catch (Throwable throwable) {
                long executionTime2 = start == -1L ? start : System.currentTimeMillis() - start;
                int sqlCount = sqlCounter == null ? -1 : sqlCounter.get();
                LoggingInterceptor.MessagePattern mp = LoggingInterceptor.MessagePattern.getInstance(executionTime2, sqlCount, exp);
                if (exp != null && !(exp instanceof ApplicationException)) {
                    webapiLogger.error(mp.format(), mp.arguments(this.makeWebApiName(invocation), executionTime2, sqlCount, exp, !ExceptionInterceptor.match(this.noStackTraceClass, exp)));
                } else if (this.isWarnLog(executionTime2, sqlCount)) {
                    webapiLogger.warn(mp.format(), mp.arguments(this.makeWebApiName(invocation), executionTime2, sqlCount, exp, webapiLogger.isDebugEnabled()));
                } else {
                    webapiLogger.info(mp.format(), mp.arguments(this.makeWebApiName(invocation), executionTime2, sqlCount, exp, webapiLogger.isDebugEnabled()));
                }
                MDC.remove((String)MDC_WEBAPI);
                throw throwable;
            }
        }
        int sqlCount = sqlCounter == null ? -1 : sqlCounter.get();
        LoggingInterceptor.MessagePattern mp = LoggingInterceptor.MessagePattern.getInstance(executionTime, sqlCount, exp);
        if (exp != null && !(exp instanceof ApplicationException)) {
            webapiLogger.error(mp.format(), mp.arguments(this.makeWebApiName(invocation), executionTime, sqlCount, exp, !ExceptionInterceptor.match(this.noStackTraceClass, exp)));
        } else if (this.isWarnLog(executionTime, sqlCount)) {
            webapiLogger.warn(mp.format(), mp.arguments(this.makeWebApiName(invocation), executionTime, sqlCount, exp, webapiLogger.isDebugEnabled()));
        } else {
            webapiLogger.info(mp.format(), mp.arguments(this.makeWebApiName(invocation), executionTime, sqlCount, exp, webapiLogger.isDebugEnabled()));
        }
        MDC.remove((String)MDC_WEBAPI);
        return string;
    }

    private boolean isWarnLog(long executionTime, int sqlCount) {
        if (this.warnLogThresholdOfSqlExecutionCount >= 0 && sqlCount > this.warnLogThresholdOfSqlExecutionCount) {
            return true;
        }
        return this.warnLogThresholdOfExecutionTimeMillis >= 0L && executionTime > this.warnLogThresholdOfExecutionTimeMillis;
    }

    private CharSequence makeWebApiName(CommandInvocation invocation) {
        RestRequestContext req = (RestRequestContext)invocation.getRequest();
        String webApiName = WebRequestStack.getCurrent().getRequestPath().getTargetPath(true);
        RequestType requestType = req.requestType();
        MethodType methodType = req.methodType();
        StringBuilder sb = new StringBuilder();
        sb.append(webApiName);
        if (req != null) {
            Object val;
            boolean isFirst;
            if (this.getLogParamName() != null) {
                isFirst = true;
                for (String p : this.getLogParamName()) {
                    val = req.getParam(p);
                    if (val == null) continue;
                    if (isFirst) {
                        sb.append("?");
                        isFirst = false;
                    } else {
                        sb.append("&");
                    }
                    if (val instanceof String[]) {
                        String[] valArray = (String[])val;
                        for (int i = 0; i < valArray.length; ++i) {
                            if (i != 0) {
                                sb.append("&");
                            }
                            sb.append(p).append("=").append(valArray[i]);
                        }
                        continue;
                    }
                    sb.append(p).append("=").append(val);
                }
            }
            if (this.getLogAttributeName() != null) {
                sb.append("[");
                isFirst = true;
                for (String p : this.getLogAttributeName()) {
                    val = req.getAttribute(p);
                    if (val == null) continue;
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(p).append("=");
                    if (val instanceof Object[]) {
                        sb.append(Arrays.toString((Object[])val));
                        continue;
                    }
                    if (val instanceof Map) {
                        this.appendMap(sb, (Map)val, null);
                        continue;
                    }
                    sb.append(val);
                }
                sb.append("]");
            }
        }
        sb.append("(").append((Object)requestType).append("/").append((Object)methodType).append(")");
        return sb;
    }

    private void appendMap(StringBuilder sb, Map map, HashSet<Map> looped) {
        Iterator i = map.entrySet().iterator();
        if (!i.hasNext()) {
            sb.append("{}");
            return;
        }
        sb.append('{');
        while (true) {
            Map.Entry e = i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            sb.append((Object)(key == map ? "(this Map)" : key));
            sb.append('=');
            if (value == map) {
                sb.append("(this Map)");
            } else if (value instanceof Object[]) {
                sb.append(Arrays.deepToString((Object[])value));
            } else if (value instanceof Map) {
                if (looped == null) {
                    looped = new HashSet();
                }
                looped.add(map);
                if (looped.contains(value)) {
                    sb.append("(looped Map)");
                } else {
                    this.appendMap(sb, (Map)value, looped);
                }
            } else {
                sb.append(value);
            }
            if (!i.hasNext()) {
                sb.append('}');
                return;
            }
            sb.append(',').append(' ');
        }
    }
}

