/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.interceptors;

import org.iplass.mtp.command.interceptor.CommandInterceptor;
import org.iplass.mtp.command.interceptor.CommandInvocation;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.authenticate.token.web.AuthorizationRequiredException;
import org.iplass.mtp.impl.auth.oauth.AccessTokenAccountHandle;
import org.iplass.mtp.impl.webapi.WebApiInvocationImpl;

public class OAuthScopeInterceptor
implements CommandInterceptor {
    public String intercept(CommandInvocation invocation) {
        WebApiInvocationImpl webApiInvocation = (WebApiInvocationImpl)invocation;
        AuthContextHolder authContext = AuthContextHolder.getAuthContext();
        if (authContext.getUserContext().getAccount() instanceof AccessTokenAccountHandle) {
            AccessTokenAccountHandle atah = (AccessTokenAccountHandle)authContext.getUserContext().getAccount();
            if (!webApiInvocation.getWebApiRuntime().isSufficientOAuthScope(atah.getAccessToken().getGrantedScopes())) {
                throw new AuthorizationRequiredException("Bearer", null, "insufficient_scope", null);
            }
        }
        return invocation.proceedCommand();
    }
}

