/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.web.template;

import java.sql.Date;
import java.sql.Time;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collection;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.prefs.MetaPreference;
import org.iplass.mtp.impl.prefs.MetaPreferenceSet;
import org.iplass.mtp.impl.prefs.PreferenceService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.ResourceBundleUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ELFunctions {
    private static Logger logger = LoggerFactory.getLogger(ELFunctions.class);
    private static PreferenceService ps = (PreferenceService)ServiceRegistry.getRegistry().getService(PreferenceService.class);

    public static RequestContext rc() {
        return TemplateUtil.getRequestContext();
    }

    public static String tcPath() {
        return TemplateUtil.getTenantContextPath();
    }

    public static String msg(String categoryName, String messageId) {
        return TemplateUtil.getMessageString(categoryName, messageId, new Object[0]);
    }

    public static String msgp(String categoryName, String messageId, Object params) {
        if (params == null) {
            return TemplateUtil.getMessageString(categoryName, messageId, new Object[0]);
        }
        if (params instanceof Object[]) {
            return TemplateUtil.getMessageString(categoryName, messageId, (Object[])params);
        }
        if (params instanceof Collection) {
            return TemplateUtil.getMessageString(categoryName, messageId, ((Collection)params).toArray(new Object[((Collection)params).size()]));
        }
        return TemplateUtil.getMessageString(categoryName, messageId, params);
    }

    public static String escJs(String str) {
        return StringUtil.escapeJavaScript((String)str);
    }

    public static String escXml(String str) {
        return StringUtil.escapeXml10((String)str);
    }

    public static String esc(String str) {
        return StringUtil.escapeHtml((String)str);
    }

    public static String outputToken(Object tokenOutputType, boolean createNew) {
        if (tokenOutputType instanceof TemplateUtil.TokenOutputType) {
            return TemplateUtil.outputToken((TemplateUtil.TokenOutputType)((Object)tokenOutputType), createNew);
        }
        return TemplateUtil.outputToken(TemplateUtil.TokenOutputType.valueOf(tokenOutputType.toString()), createNew);
    }

    public static String token() {
        return TemplateUtil.outputToken(TemplateUtil.TokenOutputType.VALUE, true);
    }

    public static String fixToken() {
        return TemplateUtil.outputToken(TemplateUtil.TokenOutputType.VALUE, false);
    }

    public static Object prefs(String name) {
        MetaPreference.PreferenceRuntime pr = (MetaPreference.PreferenceRuntime)ps.getRuntimeByName(name);
        if (pr == null) {
            return null;
        }
        if (pr.getRuntime() != null) {
            return pr.getRuntime();
        }
        if (pr instanceof MetaPreferenceSet.PreferenceSetRuntime) {
            return pr.getMap();
        }
        return pr.getMetaData().getValue();
    }

    public static String fmt(Object value, String pattern) {
        try {
            if (value instanceof Date) {
                SimpleDateFormat fmt = DateUtil.getSimpleDateFormat((String)pattern, (boolean)false);
                return fmt.format((Date)value);
            }
            if (value instanceof Time) {
                SimpleDateFormat fmt = DateUtil.getSimpleDateFormat((String)pattern, (boolean)false);
                return fmt.format((Time)value);
            }
            if (value instanceof java.util.Date) {
                SimpleDateFormat fmt = DateUtil.getSimpleDateFormat((String)pattern, (boolean)true);
                return fmt.format((java.util.Date)value);
            }
            if (value instanceof Number) {
                DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(ExecuteContext.getCurrentContext().getLocale());
                DecimalFormat fmt = new DecimalFormat(pattern, dfs);
                return fmt.format(value);
            }
        }
        catch (RuntimeException e) {
            logger.debug("cant format:" + value + ",pattern:" + pattern + ", " + e);
        }
        return null;
    }

    public static Object nvl(Object val, Object defaultVal) {
        if (val != null) {
            return val;
        }
        return defaultVal;
    }

    public static String rs(String baseName, String key) {
        return TemplateUtil.getResourceString(ResourceBundleUtil.getResourceBundle((String)baseName), key, new Object[0]);
    }

    public static String rsp(String baseName, String key, Object params) {
        if (params == null) {
            return TemplateUtil.getResourceString(ResourceBundleUtil.getResourceBundle((String)baseName), key, new Object[0]);
        }
        if (params instanceof Object[]) {
            return TemplateUtil.getResourceString(ResourceBundleUtil.getResourceBundle((String)baseName), key, (Object[])params);
        }
        if (params instanceof Collection) {
            return TemplateUtil.getResourceString(ResourceBundleUtil.getResourceBundle((String)baseName), key, ((Collection)params).toArray(new Object[((Collection)params).size()]));
        }
        return TemplateUtil.getResourceString(ResourceBundleUtil.getResourceBundle((String)baseName), key, params);
    }
}

