/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.web.template;

import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.jsp.PageContext;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.RequestContextWrapper;
import org.iplass.mtp.definition.LocalizedStringDefinition;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.I18nService;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.LanguageFonts;
import org.iplass.mtp.impl.i18n.LocaleFormat;
import org.iplass.mtp.impl.util.PlatformUtil;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.token.TokenStore;
import org.iplass.mtp.message.MessageCategory;
import org.iplass.mtp.message.MessageItem;
import org.iplass.mtp.message.MessageManager;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.util.CollectionUtil;
import org.iplass.mtp.util.ResourceBundleUtil;
import org.iplass.mtp.util.StringUtil;

public class TemplateUtil {
    private static MessageManager mm = (MessageManager)ManagerLocator.getInstance().getManager(MessageManager.class);

    public static String getStaticContentPath() {
        return WebUtil.getStaticContentPath();
    }

    public static String getTenantContextPath() {
        return WebUtil.getTenantContextPath(WebRequestStack.getCurrent().getRequest());
    }

    public static String getResourceContentPath(String resourcePath) {
        if (resourcePath == null || resourcePath.isEmpty()) {
            return "";
        }
        if (resourcePath.startsWith("/")) {
            return TemplateUtil.getStaticContentPath() + resourcePath;
        }
        if (resourcePath.startsWith("http")) {
            return resourcePath;
        }
        return TemplateUtil.getTenantContextPath() + "/" + resourcePath;
    }

    public static RequestContext getRequestContext() {
        return WebUtil.getRequestContext();
    }

    public static Tenant getTenant() {
        return ExecuteContext.getCurrentContext().getCurrentTenant();
    }

    public static int getClientTenantId() {
        return TemplateUtil.getTenant().getId();
    }

    public static void includeTemplate(String templateName, PageContext pageContext) throws IOException, ServletException {
        WebRequestStack current = WebRequestStack.getCurrent();
        if (pageContext == null && current.getPageContext() != null) {
            pageContext = current.getPageContext();
        }
        WebUtil.includeTemplate(templateName, current.getRequest(), current.getResponse(), current.getServletContext(), pageContext);
    }

    public static void includeTemplate(String templateName, PageContext pageContext, RequestContextWrapper requestContext) throws IOException, ServletException {
        WebRequestStack current = WebRequestStack.getCurrent();
        if (pageContext == null && current.getPageContext() != null) {
            pageContext = current.getPageContext();
        }
        WebUtil.includeTemplate(templateName, current.getRequest(), current.getResponse(), current.getServletContext(), pageContext, requestContext);
    }

    public static void include(String actionName, PageContext pageContext) throws IOException, ServletException {
        WebRequestStack current = WebRequestStack.getCurrent();
        if (pageContext == null && current.getPageContext() != null) {
            pageContext = current.getPageContext();
        }
        WebUtil.include(actionName, current.getRequest(), current.getResponse(), current.getServletContext(), pageContext);
    }

    public static void include(String actionName, PageContext pageContext, RequestContextWrapper requestContext) throws IOException, ServletException {
        WebRequestStack current = WebRequestStack.getCurrent();
        if (pageContext == null && current.getPageContext() != null) {
            pageContext = current.getPageContext();
        }
        WebUtil.include(actionName, current.getRequest(), current.getResponse(), current.getServletContext(), pageContext, requestContext);
    }

    public static void renderContent(PageContext pageContext) throws IOException, ServletException {
        WebRequestStack current = WebRequestStack.getCurrent();
        if (pageContext == null && current.getPageContext() != null) {
            pageContext = current.getPageContext();
        }
        WebUtil.renderContent(current.getRequest(), current.getResponse(), current.getServletContext(), pageContext);
    }

    public static String outputToken(TokenOutputType outputStyle) {
        return TemplateUtil.outputToken(outputStyle, true);
    }

    public static String outputToken(TokenOutputType outputStyle, boolean createNew) {
        String token = createNew ? TokenStore.createNewToken(TemplateUtil.getRequestContext().getSession()) : TokenStore.getFixedToken(TemplateUtil.getRequestContext().getSession());
        switch (outputStyle) {
            case URL: {
                return "_t=" + token;
            }
            case FORM_HTML: {
                return "<input type=\"hidden\" name=\"_t\" value=\"" + token + "\" >";
            }
            case FORM_XHTML: {
                return "<input type=\"hidden\" name=\"_t\" value=\"" + token + "\" />";
            }
            case VALUE: {
                return token;
            }
        }
        return "";
    }

    public static Timestamp getCurrentTimestamp() {
        return ExecuteContext.getCurrentContext().getCurrentTimestamp();
    }

    @Deprecated
    public static String getString(String key) {
        return TemplateUtil.getString(key, null);
    }

    @Deprecated
    public static String getString(String key, Object ... arguments) {
        return TemplateUtil.getResourceString(key, arguments);
    }

    public static String getResourceString(String key, Object ... arguments) {
        return ResourceBundleUtil.resourceString((String)key, (Object[])arguments);
    }

    public static String getResourceString(ResourceBundle resource, String key, Object ... arguments) {
        return ResourceBundleUtil.resourceString((ResourceBundle)resource, (String)key, (Object[])arguments);
    }

    public static String getAPIVersion() {
        return PlatformUtil.getAPIVersion();
    }

    public static Map<String, String> getEnableLanguages() {
        I18nService i18n = (I18nService)ServiceRegistry.getRegistry().getService(I18nService.class);
        return i18n.getEnableLanguagesMap();
    }

    public static MessageCategory getMessageCategory(String catName) {
        return (MessageCategory)mm.get(catName);
    }

    public static String getMessageString(String catName, String msgId, Object ... args) {
        return TemplateUtil.getMessageString(mm.getMessageItem(catName, msgId), args);
    }

    public static String getMessageString(MessageItem message, Object ... args) {
        if (message == null) {
            return null;
        }
        String str = I18nUtil.stringDef((String)message.getMessage(), (List)message.getLocalizedMessageList());
        if (args != null) {
            return MessageFormat.format(str, args);
        }
        return str;
    }

    public static String getMultilingualString(String defaultString, List<LocalizedStringDefinition> localizedStringList) {
        return I18nUtil.stringDef((String)defaultString, localizedStringList);
    }

    public static String getMultilingualString(String viewString, List<LocalizedStringDefinition> viewLocalizedStringList, String propDefString, List<LocalizedStringDefinition> propDefLocalizedStringList) {
        String propDefLabel = I18nUtil.stringDef((String)propDefString, propDefLocalizedStringList);
        if (StringUtil.isBlank((String)viewString)) {
            return propDefLabel;
        }
        String viewLabel = I18nUtil.stringDef((String)viewString, viewLocalizedStringList);
        if (StringUtil.isBlank((String)viewLabel)) {
            return propDefLabel;
        }
        return viewLabel;
    }

    public static String getLanguage() {
        return ExecuteContext.getCurrentContext().getLanguage();
    }

    public static Locale getLocale() {
        return ExecuteContext.getCurrentContext().getLocale();
    }

    public static TimeZone getTimeZone() {
        return ExecuteContext.getCurrentContext().getTimeZone();
    }

    public static LocaleFormat getLocaleFormat() {
        return ExecuteContext.getCurrentContext().getLocaleFormat();
    }

    public static String getLanguageFonts(String langage) {
        I18nService i18n = (I18nService)ServiceRegistry.getRegistry().getService(I18nService.class);
        for (LanguageFonts fonts : i18n.getLanguageFonts()) {
            if (!fonts.getLanguage().equals(langage)) continue;
            return TemplateUtil.getLangFont(fonts);
        }
        return null;
    }

    private static String getLangFont(LanguageFonts fonts) {
        List genericFontFamilyList = ((I18nService)ServiceRegistry.getRegistry().getService(I18nService.class)).getGenericFontFamilyList();
        boolean isNotEmptyGenericFontFamilyList = CollectionUtil.isNotEmpty((Collection)genericFontFamilyList);
        String genericFontFamily = null;
        StringBuilder sb = new StringBuilder();
        for (String font : fonts.getFonts()) {
            if (isNotEmptyGenericFontFamilyList && genericFontFamilyList.contains(font)) {
                genericFontFamily = font;
                continue;
            }
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append("\"").append(font).append("\"");
        }
        if (genericFontFamily != null) {
            sb.append(",").append(genericFontFamily);
        }
        return sb.toString();
    }

    public static enum TokenOutputType {
        URL,
        FORM_HTML,
        FORM_XHTML,
        VALUE;

    }
}

