/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.matcher;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class MultilineTextMatcher
extends TypeSafeMatcher<String> {
    private static final String LINE_SEPARATOR = "\n";
    private static final String LINE_ENDING = "\\r\\n|\\r|\\n";
    private final String originalText;

    public MultilineTextMatcher(String originalText) {
        this.originalText = originalText;
    }

    public boolean matchesSafely(String text) {
        return text.equals(this.originalText);
    }

    protected void describeMismatchSafely(String text, Description mismatchDescription) {
        List<String> originalLines = this.splitPreservingNewLines(this.originalText);
        List<String> lines = this.splitPreservingNewLines(text);
        int originalLineCount = originalLines.size();
        int lineCount = lines.size();
        mismatchDescription.appendText(this.describeLineCount(lineCount));
        int i = 0;
        while (i < lineCount) {
            String line = lines.get(i);
            if (i > originalLineCount - 1) {
                mismatchDescription.appendText("+>> ");
            } else if (line.equals(originalLines.get(i))) {
                mismatchDescription.appendText("    ");
            } else {
                mismatchDescription.appendText(">>> ");
            }
            mismatchDescription.appendText(line);
            mismatchDescription.appendText(LINE_SEPARATOR);
            ++i;
        }
    }

    private String describeLineCount(int lineCount) {
        return "(" + lineCount + " lines)" + LINE_SEPARATOR;
    }

    public void describeTo(Description description) {
        List<String> originalLines = this.splitPreservingNewLines(this.originalText);
        int originalLineCount = originalLines.size();
        description.appendText(this.describeLineCount(originalLineCount));
        for (String line : originalLines) {
            description.appendText("    ");
            description.appendText(line);
            description.appendText(LINE_SEPARATOR);
        }
    }

    public static MultilineTextMatcher matchesAllLines(String ... lines) {
        return new MultilineTextMatcher(String.join((CharSequence)LINE_SEPARATOR, lines));
    }

    private List<String> splitPreservingNewLines(String text) {
        String lineSplittingRegEx = "(?<=\\r\\n|\\r|\\n)";
        ArrayList<String> lines = new ArrayList<String>();
        String[] stringArray = text.split("(?<=\\r\\n|\\r|\\n)");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            line = line.replace('\n', '\u240a').replace('\r', '\u240d').replace('\t', '\u2409');
            lines.add(line);
            ++n2;
        }
        return lines;
    }
}

