/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.vertx.maven;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.maven.MavenCoords;
import io.vertx.maven.MavenVerticleFactory;
import io.vertx.maven.Resolver;
import io.vertx.maven.ResolverOptions;
import io.vertx.maven.resolver.ResolutionOptions;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;
import org.iworkz.genesis.vertx.maven.MavenServiceFactoryException;
import org.iworkz.genesis.vertx.maven.MavenServiceOptions;

public class GenesisMavenVerticleFactory
extends MavenVerticleFactory {
    private static final Logger log = LoggerFactory.getLogger(GenesisMavenVerticleFactory.class);
    private static final String PREFIX = "genesis-maven";
    private Map<byte[], MavenServiceOptions> serviceOptionsMap = new HashMap<byte[], MavenServiceOptions>();
    private Vertx vertx;

    public GenesisMavenVerticleFactory() {
    }

    public GenesisMavenVerticleFactory(ResolverOptions options) {
        this(Resolver.create((ResolverOptions)options));
    }

    public GenesisMavenVerticleFactory(Resolver resolver) {
        super(resolver);
    }

    public void init(Vertx vertx) {
        super.init(vertx);
        this.vertx = vertx;
        log.info((Object)("Init " + ((Object)((Object)this)).getClass().getCanonicalName()));
    }

    public String prefix() {
        return PREFIX;
    }

    public void createVerticle(String verticleName, DeploymentOptions deploymentOptions, ClassLoader classLoader, Promise<Callable<Verticle>> promise) {
        log.info((Object)("Create verticle " + verticleName));
        this.vertx.executeBlocking(executionPromise -> {
            try {
                String identifierNoPrefix;
                String coordsString = identifierNoPrefix = VerticleFactory.removePrefix((String)verticleName);
                String serviceName = null;
                int pos = identifierNoPrefix.lastIndexOf("::");
                if (pos != -1) {
                    coordsString = identifierNoPrefix.substring(0, pos);
                    serviceName = identifierNoPrefix.substring(pos + 2);
                }
                MavenServiceOptions serviceOptions = this.createServiceOptions(coordsString, identifierNoPrefix, serviceName, classLoader);
                DeploymentOptions effectiveDeploymentOptions = this.createDeplomentOptionsWithClassLoader(deploymentOptions, serviceOptions);
                AbstractVerticle wrapperVerticle = this.createWrapperVerticle(serviceOptions.getMainVerticleName(), serviceOptions, effectiveDeploymentOptions);
                executionPromise.complete(() -> wrapperVerticle);
            }
            catch (Exception e) {
                log.error((Object)e);
                Throwable cause = this.findRootMavenServiceFactoryException(e);
                executionPromise.fail(cause);
            }
        }, false, ar -> {
            if (ar.succeeded()) {
                log.info((Object)("Successfully deployed " + this.prefix() + " verticle" + verticleName));
                promise.complete((Object)((Callable)ar.result()));
            } else {
                log.error((Object)("Failed to deploy " + this.prefix() + " verticle" + verticleName), ar.cause());
                promise.fail(ar.cause());
            }
        });
    }

    private DeploymentOptions createDeplomentOptionsWithClassLoader(DeploymentOptions deploymentOptions, MavenServiceOptions serviceOptions) {
        DeploymentOptions effectiveDeploymentOptions = null;
        if (serviceOptions.getDeploymentOptions() != null) {
            JsonObject mergedDeploymentOptions = deploymentOptions.toJson();
            mergedDeploymentOptions.mergeIn(serviceOptions.getDeploymentOptions());
            effectiveDeploymentOptions = new DeploymentOptions(mergedDeploymentOptions);
        } else {
            effectiveDeploymentOptions = deploymentOptions;
        }
        effectiveDeploymentOptions.setClassLoader((ClassLoader)serviceOptions.getUrlClassLoader());
        return effectiveDeploymentOptions;
    }

    protected Throwable findRootMavenServiceFactoryException(Throwable ex) {
        if (ex.getCause() instanceof MavenServiceFactoryException) {
            return this.findRootMavenServiceFactoryException(ex.getCause());
        }
        return ex;
    }

    protected JsonObject getServiceDescriptor(ClassLoader classLoader, String serviceName) {
        JsonObject jsonObject;
        block9: {
            String descriptorFile = serviceName + ".json";
            InputStream is = classLoader.getResourceAsStream(descriptorFile);
            try {
                if (is == null) {
                    throw new MavenServiceFactoryException("Cannot find service descriptor file " + descriptorFile + " on classpath");
                }
                jsonObject = this.readDescriptor(is, descriptorFile);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MavenServiceFactoryException("Failed to read " + descriptorFile, e);
                }
            }
            is.close();
        }
        return jsonObject;
    }

    protected JsonObject readDescriptor(InputStream is, String descriptorFileName) {
        Scanner scanner = new Scanner(is, "UTF-8").useDelimiter("\\A");
        try {
            String conf = scanner.next();
            JsonObject jsonObject = new JsonObject(conf);
            if (scanner != null) {
                scanner.close();
            }
            return jsonObject;
        }
        catch (Throwable throwable) {
            try {
                if (scanner != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException(descriptorFileName + " is empty");
            }
            catch (DecodeException e) {
                throw new IllegalArgumentException(descriptorFileName + " contains invalid json");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MavenServiceOptions createServiceOptions(String coordsString, String identifierNoPrefix, String serviceName, ClassLoader classLoader) {
        MavenCoords coords = new MavenCoords(coordsString);
        if (coords.version() == null) {
            throw new IllegalArgumentException("Invalid service identifier, missing version: " + coordsString);
        }
        List<Artifact> artifacts = this.resolveArtifacts(coordsString);
        MavenServiceOptions serviceOptions = null;
        for (Artifact result : artifacts) {
            if (!result.getGroupId().equals(coords.owner()) || !result.getArtifactId().equals(coords.serviceName())) continue;
            File file = result.getFile();
            byte[] checksum = this.checksumOf(file);
            Map<byte[], MavenServiceOptions> map = this.serviceOptionsMap;
            synchronized (map) {
                serviceOptions = this.serviceOptionsMap.computeIfAbsent(checksum, c -> {
                    URLClassLoader urlClassLoader = this.createClassLoader(artifacts, classLoader);
                    log.info((Object)("Register maven service: " + coordsString));
                    return this.createServiceOptions(urlClassLoader, file, checksum, identifierNoPrefix, serviceName);
                });
                serviceOptions.incrementUsage();
            }
        }
        return serviceOptions;
    }

    protected MavenServiceOptions createServiceOptions(URLClassLoader urlClassLoader, File file, byte[] checksum, String identifierNoPrefix, String serviceName) {
        String mainVerticleClassName;
        JsonObject deploymentOptions = null;
        if (serviceName == null) {
            mainVerticleClassName = this.getMainVerticleNameFromManifest(file, identifierNoPrefix);
        } else {
            JsonObject descriptor = this.getServiceDescriptor(urlClassLoader, serviceName);
            if (descriptor == null) {
                throw new MavenServiceFactoryException("Cannot find service descriptor file " + serviceName + ".json");
            }
            mainVerticleClassName = descriptor.getString("main");
            if (mainVerticleClassName == null) {
                throw new MavenServiceFactoryException(serviceName + ".json does not contain a main field");
            }
            deploymentOptions = descriptor.getJsonObject("options", new JsonObject());
        }
        log.info((Object)("Create service options: " + mainVerticleClassName));
        return new MavenServiceOptions(checksum, mainVerticleClassName, urlClassLoader, deploymentOptions);
    }

    protected List<Artifact> resolveArtifacts(String coordsString) {
        try {
            return this.getResolver().resolve(coordsString, new ResolutionOptions());
        }
        catch (NullPointerException e) {
            throw new MavenServiceFactoryException("Cannot find module " + coordsString + ". Maybe repository URL is invalid?");
        }
    }

    protected String getMainVerticleNameFromManifest(File file, String identifierNoPrefix) {
        String string;
        JarFile jarFile = new JarFile(file);
        try {
            String serviceIdentifer = null;
            Manifest manifest = jarFile.getManifest();
            if (manifest != null) {
                serviceIdentifer = (String)manifest.getMainAttributes().get(new Attributes.Name("Main-Verticle"));
                if (serviceIdentifer == null) {
                    throw new IllegalStateException("Failed to get name of 'Main-Verticle' in manifest " + identifierNoPrefix);
                }
            } else {
                throw new IllegalStateException("Invalid service identifier, missing 'Main-Verticle' attribute: " + identifierNoPrefix);
            }
            string = serviceIdentifer;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new MavenServiceFactoryException("Invalid service identifier", ex);
            }
        }
        jarFile.close();
        return string;
    }

    protected URLClassLoader createClassLoader(List<Artifact> artifacts, ClassLoader parentClassLoader) {
        List classpath = artifacts.stream().map(res -> res.getFile().getAbsolutePath()).collect(Collectors.toList());
        URL[] urls = new URL[classpath.size()];
        int index = 0;
        ArrayList<String> extraCP = new ArrayList<String>(urls.length);
        for (String pathElement : classpath) {
            File claspathFile = new File(pathElement);
            extraCP.add(claspathFile.getAbsolutePath());
            try {
                URL url = claspathFile.toURI().toURL();
                urls[index++] = url;
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        return new URLClassLoader(urls, parentClassLoader);
    }

    protected byte[] checksumOf(File file) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            this.computeDigest(file, md);
            return md.digest();
        }
        catch (Exception e) {
            throw new MavenServiceFactoryException("Failed to get checksum of file: " + file.getAbsolutePath(), e);
        }
    }

    protected void computeDigest(File file, MessageDigest md) {
        byte[] buffer = new byte[1024];
        try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
             DigestInputStream dis = new DigestInputStream(is, md);){
            while (is.read(buffer) > 0) {
            }
        }
        catch (Exception e) {
            throw new MavenServiceFactoryException("Failed to compute digest of file: " + file.getAbsolutePath(), e);
        }
    }

    protected AbstractVerticle createWrapperVerticle(final String fullQualifiedVerticleName, final MavenServiceOptions serviceOptions, final DeploymentOptions deploymentOptions) {
        return new AbstractVerticle(){

            public void start(Promise<Void> startPromise) {
                if (deploymentOptions.getConfig() == null) {
                    deploymentOptions.setConfig(new JsonObject());
                }
                deploymentOptions.getConfig().mergeIn(this.context.config());
                this.vertx.deployVerticle(fullQualifiedVerticleName, deploymentOptions).onSuccess(deploymentId -> log.info((Object)("Successfully deployed verticle: " + serviceOptions.getMainVerticleName()))).mapEmpty().onComplete(startPromise);
            }

            public void stop(Promise<Void> stopPromise) {
                this.removeDeployment();
                stopPromise.complete();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeDeployment() {
                log.info((Object)("Successfully undeployed verticle: " + serviceOptions.getMainVerticleName()));
                Map<byte[], MavenServiceOptions> map = GenesisMavenVerticleFactory.this.serviceOptionsMap;
                synchronized (map) {
                    if (serviceOptions.decrementAndGetUsage() == 0) {
                        GenesisMavenVerticleFactory.this.serviceOptionsMap.remove(serviceOptions.getChecksum());
                        try {
                            serviceOptions.getUrlClassLoader().close();
                        }
                        catch (Exception e) {
                            log.error((Object)("Failed to close classloader for verticle: " + serviceOptions.getMainVerticleName()));
                            e.printStackTrace();
                        }
                        log.info((Object)("Unregister verticle: " + serviceOptions.getMainVerticleName()));
                    }
                }
            }
        };
    }

    static {
        String remoteRepositoriesEnv = System.getenv("MAVEN_REMOTE_REPOS");
        if (remoteRepositoriesEnv != null && !remoteRepositoriesEnv.isEmpty()) {
            System.setProperty("vertx.maven.remoteRepos", remoteRepositoriesEnv);
        }
    }
}

