package org.iworkz.genesis.vertx.common.context;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;

import org.iworkz.genesis.vertx.common.mapping.SimpleTypeMapper;

import io.vertx.ext.auth.User;


public abstract class AbstractRequestContext implements RESTContext {

    private SimpleTypeMapper simpleTypeMapper;
    private final User user;
    private final Map<String, Object> data;

    protected AbstractRequestContext(User user, Map<String, Object> data, SimpleTypeMapper simpleTypeMapper) {
        this.simpleTypeMapper = simpleTypeMapper;
        this.user = user;
        this.data = Collections.unmodifiableMap(data);
    }

    @Override
    public String getStringParam(String name) {
        return getSimpleTypeMapper().stringFrom(getParam(name));
    }

    @Override
    public Character getCharacterParam(String name) {
        return getSimpleTypeMapper().characterFrom(getParam(name));
    }

    @Override
    public Boolean getBooleanParam(String name) {
        return getSimpleTypeMapper().booleanFrom(getParam(name));
    }

    @Override
    public Integer getIntegerParam(String name) {
        return getSimpleTypeMapper().integerFrom(getParam(name));
    }

    @Override
    public Long getLongParam(String name) {
        return getSimpleTypeMapper().longFrom(getParam(name));
    }

    @Override
    public UUID getUUIDParam(String name) {
        return getSimpleTypeMapper().UUIDFrom(getParam(name));
    }

    public SimpleTypeMapper getSimpleTypeMapper() {
        return simpleTypeMapper;
    }

    @Override
    public User user() {
        return user;
    }

    @Override
    public <T> T getContextData(String name) {
        return (T) data.get(name);
    }

}
