package org.iworkz.genesis.vertx.common.context;

import java.util.Map;

import org.iworkz.genesis.vertx.common.mapping.SimpleTypeMapper;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.ext.auth.User;

public class EventBusRequestContext extends AbstractRequestContext {

    private final Message<Buffer> message;


    public EventBusRequestContext(Message<Buffer> message, User user, Map<String, Object> data,
                                  SimpleTypeMapper simpleTypeMapper) {
        super(user, data, simpleTypeMapper);
        this.message = message;
    }

    @Override
    public MultiMap headers() {
        return message.headers();
    }

    @Override
    public Future<Buffer> body() {
        return Future.succeededFuture(message.body());
    }

    @Override
    public Object getParam(String name) {
        return message.headers().get(name);
    }

}
