package org.iworkz.genesis.vertx.common.context;

import java.util.Map;

import org.iworkz.genesis.vertx.common.mapping.SimpleTypeMapper;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.auth.User;

public class HttpRequestContext extends AbstractRequestContext {

    private final HttpServerRequest request;

    public HttpRequestContext(HttpServerRequest request, User user, Map<String, Object> data, SimpleTypeMapper simpleTypeMapper) {
        super(user, data, simpleTypeMapper);
        this.request = request;
    }

    @Override
    public MultiMap headers() {
        return request.headers();
    }

    @Override
    public Future<Buffer> body() {
        request.resume();
        return request.body();
    }

    @Override
    public Object getParam(String name) {
        return request.getParam(name);
    }

}
