package org.iworkz.genesis.vertx.common.context;

import java.util.Map;
import java.util.UUID;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.auth.User;

public interface RESTContext {

    Object getParam(String name);

    /**
     * Get a String parameter by name
     *
     * @param name Parameter name
     * @return
     */
    String getStringParam(String name);

    /**
     * Get a Character parameter by name
     *
     * @param name Parameter name
     * @return
     */
    Character getCharacterParam(String name);

    /**
     * Get a String parameter by name
     *
     * @param name Parameter name
     * @return
     */
    Boolean getBooleanParam(String name);

    /**
     * Get a Integer parameter by name
     *
     * @param name Parameter name
     * @return
     */
    Integer getIntegerParam(String name);

    /**
     * Get a Long parameter by name
     *
     * @param name Parameter name
     * @return
     */
    Long getLongParam(String name);

    /**
     * Get a UUID parameter by name
     *
     * @param name Parameter name
     * @return
     */
    UUID getUUIDParam(String name);

    /**
     * Get the headers
     * 
     * @return
     */
    MultiMap headers();

    /**
     * Get the body
     * 
     * @return
     */
    Future<Buffer> body();

    /**
     * Get the user
     * 
     * @return
     */
    User user();

    /**
     * Get context data
     * 
     * @param <T>
     * @param metaDataName
     * @return
     */
    <T> T getContextData(String metaDataName);

}
