package org.iworkz.genesis.vertx.common.context;


import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Transaction;

public interface TransactionContext extends CommandContext {

    Transaction getTransaction();

    SqlConnection getConnection();

    Future<TransactionContext> begin();

    <T> Future<T> commit(T t);

    <T> Future<T> rollback(Throwable cause);
    
    <T> Future<T> close(AsyncResult<T> res);

    <T> Future<T> close(T t);
    
    <T> Future<Void> close();

}
