package org.iworkz.genesis.vertx.common.mapping;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;

import javax.inject.Singleton;

@Singleton
public class SimpleTypeMapper {

    public String stringFrom(Object value) {
        if (value instanceof String) {
            return (String) value;
        } else if (value == null) {
            return null;
        } else {
            return value.toString();
        }
    }

    public Character characterFrom(Object value) {
        if (value instanceof Character) {
            return (Character) value;
        } else if (value instanceof String) {
            String string = (String) value;
            if (string.length() == 1) {
                return string.charAt(0);
            } else {
                throw new IllegalArgumentException("Failed to get Character value from String '" + value.toString() + "'");
            }
        } else if (value instanceof Number) {
            Number number = (Number) value;
            int intValue = number.intValue();
            if (intValue >= 0 && intValue <= 9) {
                return number.toString().charAt(0);
            } else {
                throw new IllegalArgumentException("Failed to get Character value from Number '" + value.toString() + "'");
            }
        } else if (value == null) {
            return null;
        } else {
            throw new IllegalArgumentException(
                    "Mapping from " + value.getClass().getCanonicalName() + " to Character is not supported");
        }
    }

    public UUID UUIDFrom(Object value) {
        if (value instanceof UUID) {
            return (UUID) value;
        } else if (value instanceof String) {
            try {
                return UUID.fromString((String) value);
            } catch (Exception ex) {
                throw new IllegalArgumentException("Failed to get UUID value from '" + value.toString() + "'", ex);
            }
        } else if (value == null) {
            return null;
        } else {
            throw new IllegalArgumentException(
                    "Mapping from " + value.getClass().getCanonicalName() + " to UUID is not supported");
        }
    }

    public Boolean booleanFrom(Object value) {
        if (value instanceof UUID) {
            return (Boolean) value;
        } else if (value instanceof String) {
            try {
                return Boolean.valueOf((String) value);
            } catch (Exception ex) {
                throw new IllegalArgumentException("Failed to get Booleam value from " + value.toString(), ex);
            }
        } else if (value == null) {
            return null;
        } else {
            throw new IllegalArgumentException(
                    "Mapping from " + value.getClass().getCanonicalName() + " to Boolean is not supported");
        }
    }

    public Byte byteFrom(Object value) {
        if (value instanceof Integer) {
            return (Byte) value;
        } else if (value instanceof String) {
            try {
                return Byte.valueOf((String) value);
            } catch (Exception ex) {
                throw new IllegalArgumentException("Failed to get Byte value from " + value.toString(), ex);
            }
        } else if (value instanceof Number) {
            return ((Number) value).byteValue();
        } else if (value == null) {
            return null;
        } else {
            throw new IllegalArgumentException(
                    "Mapping from " + value.getClass().getCanonicalName() + " to Byte is not supported");
        }
    }

    public Short shortFrom(Object value) {
        if (value instanceof Short) {
            return (Short) value;
        } else if (value instanceof String) {
            try {
                return Short.valueOf((String) value);
            } catch (Exception ex) {
                throw new IllegalArgumentException("Failed to get Short value from " + value.toString(), ex);
            }
        } else if (value instanceof Number) {
            return ((Number) value).shortValue();
        } else if (value == null) {
            return null;
        } else {
            throw new IllegalArgumentException(
                    "Mapping from " + value.getClass().getCanonicalName() + " to Short is not supported");
        }
    }

    public Integer integerFrom(Object value) {
        if (value instanceof Integer) {
            return (Integer) value;
        } else if (value instanceof String) {
            try {
                return Integer.valueOf((String) value);
            } catch (Exception ex) {
                throw new IllegalArgumentException("Failed to get Integer value from " + value.toString(), ex);
            }
        } else if (value instanceof Number) {
            return ((Number) value).intValue();
        } else if (value == null) {
            return null;
        } else {
            throw new IllegalArgumentException(
                    "Mapping from " + value.getClass().getCanonicalName() + " to Integer is not supported");
        }
    }

    public Long longFrom(Object value) {
        if (value instanceof Long) {
            return (Long) value;
        } else if (value instanceof String) {
            try {
                return Long.valueOf((String) value);
            } catch (Exception ex) {
                throw new IllegalArgumentException("Failed to get Long value from " + value.toString(), ex);
            }
        } else if (value instanceof Number) {
            return ((Number) value).longValue();
        } else if (value == null) {
            return null;
        } else {
            throw new IllegalArgumentException(
                    "Mapping from " + value.getClass().getCanonicalName() + " to Long is not supported");
        }
    }

    public Double doubleFrom(Object value) {
        if (value instanceof Double) {
            return (Double) value;
        } else if (value instanceof String) {
            try {
                return Double.valueOf((String) value);
            } catch (Exception ex) {
                throw new IllegalArgumentException("Failed to get Long value from " + value.toString(), ex);
            }
        } else if (value instanceof Number) {
            return ((Number) value).doubleValue();
        } else if (value == null) {
            return null;
        } else {
            throw new IllegalArgumentException(
                    "Mapping from " + value.getClass().getCanonicalName() + " to Double is not supported");
        }
    }

    public BigDecimal bigDecimalFrom(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal) value;
        } else if (value instanceof String) {
            try {
                return new BigDecimal((String) value);
            } catch (Exception ex) {
                throw new IllegalArgumentException("Failed to get Long value from " + value.toString(), ex);
            }
        } else if (value instanceof Number) {
            if (value instanceof Double) {
                return BigDecimal.valueOf((Double) value);
            } else if (value instanceof Integer) {
                return new BigDecimal((Integer) value);
            } else if (value instanceof Long) {
                return new BigDecimal((Long) value);
            } else {
                return new BigDecimal(value.toString());
            }
        } else if (value == null) {
            return null;
        } else {
            throw new IllegalArgumentException(
                    "Mapping from " + value.getClass().getCanonicalName() + " to BigDecimal is not supported");
        }
    }

    public BigInteger bigIntegerFrom(Object value) {
        if (value instanceof BigInteger) {
            return (BigInteger) value;
        } else if (value instanceof String) {
            try {
                return new BigInteger((String) value);
            } catch (Exception ex) {
                throw new IllegalArgumentException("Failed to get Long value from " + value.toString(), ex);
            }
        } else if (value instanceof Number) {
            if (value instanceof Integer) {
                return BigInteger.valueOf(((Integer) value).longValue());
            } else if (value instanceof Long) {
                return BigInteger.valueOf((Long) value);
            } else {
                return new BigInteger(value.toString());
            }
        } else if (value == null) {
            return null;
        } else {
            throw new IllegalArgumentException(
                    "Mapping from " + value.getClass().getCanonicalName() + " to BigInteger is not supported");
        }
    }

}
