package org.iworkz.genesis.vertx.common.query;

import java.util.HashMap;
import java.util.Map;

public class QuerySpecification {

    private int page;
    private int pageSize;
    private String filter;
    private Map<String, FilterCriteria> filterCriterias;
    private String sortBy;
    private boolean descending;

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getFilter() {
        return filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public QuerySpecification addFilterCriteria(String name, Object value) {
        return addFilterCriteria(new FilterCriteria(name, value));
    }

    public QuerySpecification addFilterCriteria(FilterCriteria filterCriteria) {
        if (filterCriterias == null) {
            filterCriterias = new HashMap<>();
        }
        filterCriterias.put(filterCriteria.getName(), filterCriteria);
        return this;
    }

    public String getSortBy() {
        return sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public boolean getDescending() {
        return descending;
    }

    public void setDescending(boolean descending) {
        this.descending = descending;
    }

    public boolean isPaged() {
        return page > 0;
    }

    public boolean isFiltered() {
        return filter != null;
    }

    public FilterCriteria getFilterCriteria(String name) {
        if (filterCriterias != null) {
            return filterCriterias.get(name);
        } else {
            return null;
        }
    }

    public boolean isSorted() {
        return sortBy != null;
    }

}
