package org.iworkz.genesis.vertx.common.router;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.ext.web.RoutingContext;

public class RESTOperation {

    private final String operationId;
    private final Handler<RoutingContext> httpHandler;
    private final Handler<Message<Buffer>> eventBusHandler;

    private String consumes;
    private String produces;

    public RESTOperation(String operationId,
                         Handler<RoutingContext> httpHandler,
                         Handler<Message<Buffer>> eventBusHandler) {
        this.operationId = operationId;
        this.httpHandler = httpHandler;
        this.eventBusHandler = eventBusHandler;
    }

    public String getOperationId() {
        return operationId;
    }

    public String getConsumes() {
        return consumes;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public String getProduces() {
        return produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public Handler<RoutingContext> getHttpHandler() {
        return httpHandler;
    }

    public Handler<Message<Buffer>> getEventBusHandler() {
        return eventBusHandler;
    }

}
