package org.iworkz.genesis.vertx.common.router;

import static io.vertx.ext.web.openapi.RouterBuilderException.createInvalidSpec;
import static io.vertx.ext.web.openapi.RouterBuilderException.createInvalidSpecFile;
import static io.vertx.ext.web.openapi.RouterBuilderException.createRouterBuilderInstantiationError;

import org.iworkz.genesis.vertx.common.controller.RESTController;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.openapi.OpenAPIHolder;
import io.vertx.ext.web.openapi.OpenAPILoaderOptions;
import io.vertx.json.schema.ValidationException;

public interface RESTRouterBuilder {

    static Future<RESTRouterBuilder> create(Vertx vertx, String url, String contractEndPoint) {
        return create(vertx, url, contractEndPoint, new OpenAPILoaderOptions());
    }

    /**
     * Create a new {@link RESTRouterBuilder}
     *
     * @param vertx
     * @param url     location of your spec. It can be an absolute path, a local path or remote url (with HTTP/HTTPS
     *                protocol)
     * @param options options for specification loading
     * @return Future completed with success when specification is loaded and valid
     */
    static Future<RESTRouterBuilder> create(Vertx vertx,
                                            String url,
                                            String contractEndPoint,
                                            OpenAPILoaderOptions options) {

        Promise<RESTRouterBuilder> promise = Promise.promise();

        HttpClient httpClient = vertx.createHttpClient();
        GenesisOpenAPIHolderImpl loader = new GenesisOpenAPIHolderImpl(vertx, httpClient, vertx.fileSystem(), options);
        loader.loadOpenAPI(url)
                .onFailure(cause -> {
                    if (cause instanceof ValidationException) {
                        promise.fail(createInvalidSpec(cause));
                    } else {
                        promise.fail(createInvalidSpecFile(url, cause));
                    }
                })
                .map(openAPI -> new RESTRouterBuilderImpl(vertx, loader, contractEndPoint))
                .onFailure(cause -> promise.tryFail(createRouterBuilderInstantiationError(cause, url)))
                .onSuccess(promise::complete);

        return promise.future();
    }

    OpenAPIHolder getOpenAPI();

    void addRESTController(RESTController controller);

    Router addRoutesTo(Router router);

}
