package org.iworkz.genesis.vertx.common.stream;

import org.iworkz.genesis.vertx.common.stream.aggregator.StreamAggregator;

import io.vertx.core.Future;

public class AggregatingStream<S, T> extends AbstractMappingStream<S, T> {

    private final StreamAggregator<S, T> aggregator;

    public AggregatingStream(StreamAggregator<S, T> aggregator) {
        this.aggregator = aggregator;
    }

    @Override
    protected <E> void handleSourceItem(E e) {
        S source = (S) e;
        aggregator.setNext(source);
        if (aggregator.isFinished()) {
            T target = aggregator.create();
            invokeTargetItemHandler(target);
            aggregator.startNew();
        } else {
            aggregator.collect();
        }
    }

    @Override
    protected Future<Void> finishItemHandling() {
        if (!aggregator.isEmpty()) {
            T target = aggregator.create();
            invokeTargetItemHandler(target);
        }
        return Future.succeededFuture();
    }

}
