package org.iworkz.genesis.vertx.common.stream;

import java.util.Iterator;
import java.util.function.Function;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.streams.ReadStream;

public class IterableReadStream<T> extends AbstractAsyncReadStream<T> {

    private Iterator<T> iterator;
    private boolean paused;

    public static <T> Future<Void> forEach(Iterable<T> iterable, Function<T, Future<Void>> handler) {
        return new IterableReadStream<T>(iterable).forEach(handler);
    }

    public IterableReadStream() {
    }

    public IterableReadStream(Iterable<T> iterable) {
        this.iterator = iterable.iterator();
        readyPromise.complete(this);
    }

    public ReadStream<T> setIterable(Iterable<T> iterable) {
        this.iterator = iterable.iterator();
        readyPromise.complete(this);
        return this;
    }

    public <S> ReadStream<T> setIterable(Iterable<S> iterable, Function<S, T> mapping) {
        Iterator<S> sourceIterator = iterable.iterator();
        iterator = new Iterator<T>() {

            @Override
            public boolean hasNext() {
                return sourceIterator.hasNext();
            }

            @Override
            public T next() {
                return mapping.apply(sourceIterator.next());
            }
        };
        readyPromise.complete(this);
        return this;
    }


    @Override
    public ReadStream<T> pause() {
        paused = true;
        return this;
    }

    @Override
    public IterableReadStream<T> resume() {
        super.resume();
        paused = false;
        return fetch(Long.MAX_VALUE);
    }

    @Override
    public synchronized IterableReadStream<T> fetch(long amount) {
        long i = 0L;
        try {
            while (!paused && i < amount && iterator.hasNext()) {
                T t = iterator.next();
                getTargetItemHandler().handle(t);
                i++;
            }
        } catch (Exception ex) {
            handleException(ex);
        }
        if (!iterator.hasNext() && getEndHandler() != null) {
            getEndHandler().handle(null);
        }
        return this;
    }

}
