package org.iworkz.genesis.vertx.common.stream;

import java.util.function.Function;

public class MappedReadStream<S, T> extends AbstractMappingStream<S, T> {

    private final Function<S, T> mapping;

    public MappedReadStream(Function<S, T> mapping) {
        this.mapping = mapping;
    }

    @Override
    protected <E> void handleSourceItem(E source) {
        T target = mapping.apply((S) source);
        invokeTargetItemHandler(target);
    }

}
