package org.iworkz.genesis.vertx.common.stream.aggregator;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractStreamAggregator<S, I, T> implements StreamAggregator<S, T> {

    private I nextTargetIdentifier;
    private I currentTargetIdentifier;
    private S next;
    private List<S> sources = new ArrayList<>();

    @Override
    public void setNext(S next) {
        this.next = next;
        nextTargetIdentifier = getTargetIdentifier(next);
        if (currentTargetIdentifier == null) {
            currentTargetIdentifier = nextTargetIdentifier;
        }
    }

    @Override
    public boolean isFinished() {
        return currentTargetIdentifier != null && !currentTargetIdentifier.equals(nextTargetIdentifier);
    }

    @Override
    public void startNew() {
        sources = new ArrayList<>();
        sources.add(next);
        next = null;
        currentTargetIdentifier = nextTargetIdentifier;
        nextTargetIdentifier = null;
    }

    @Override
    public boolean isEmpty() {
        return sources.isEmpty();
    }

    @Override
    public void collect() {
        sources.add(next);
    }

    protected boolean belongsToCurrentTarget(I targetIdentifier) {
        if (currentTargetIdentifier == null) {
            currentTargetIdentifier = targetIdentifier;
            return true;
        } else if (currentTargetIdentifier.equals(targetIdentifier)) {
            return true;
        }
        return false;
    }


    protected I getCurrentTargetIdentifier() {
        return currentTargetIdentifier;
    }

    protected List<S> getSources() {
        return sources;
    }

    protected abstract I getTargetIdentifier(S source);

}
