package org.iworkz.genesis.vertx.common.util;

import java.util.function.Function;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;

public class FutureUtil {
	
    private static final Logger log = LoggerFactory.getLogger(FutureUtil.class);

    public static <T> Function<T, T> with(Handler<T> h) {
        return new Function<T, T>() {
            @Override
            public T apply(T t) {
                h.handle(t);
                return t;
            }
        };
    }
    
    public static <T> Future<T> eventuallyTakeFailure(AsyncResult<T> res, Function<Void, Future<?>> mapper) {
        try {
            if (res.failed()) {
                return mapper.apply(null)
                        .onFailure(ex -> {
                            if (log.isInfoEnabled()) {
                                log.error("Ignored exception: {}", ex.getMessage(), ex);
                            }
                        })
                        .compose(mRes -> Future.failedFuture(res.cause()));
            } else {
                return mapper.apply(null).map(mapperResult -> res.result());
            }
        } catch (Exception ex) {
            if (res.failed()) {
                if (log.isInfoEnabled()) {
                    log.error("Ignored exception: {}", ex.getMessage(), ex);
                }
                return Future.failedFuture(res.cause());
            } else {
                return Future.failedFuture(ex);
            }
        }
    }

}
