/*
 * Decompiled with CFR 0.152.
 */
package org.jamgo.vaadin.ui.builder;

import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.datepicker.DatePicker;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.format.TextStyle;
import java.time.temporal.WeekFields;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jamgo.services.message.LocalizedMessageService;
import org.jamgo.vaadin.builder.base.FocusableBuilder;
import org.jamgo.vaadin.builder.base.HasHelperBuilder;
import org.jamgo.vaadin.builder.base.HasSizeBuilder;
import org.jamgo.vaadin.builder.base.HasStyleBuilder;
import org.jamgo.vaadin.builder.base.HasValidationBuilder;
import org.jamgo.vaadin.builder.base.HasValueBuilder;
import org.jamgo.vaadin.ui.builder.JamgoComponentBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DateFieldBuilder
extends JamgoComponentBuilder<DatePicker, DateFieldBuilder>
implements HasSizeBuilder<DateFieldBuilder, DatePicker>,
HasStyleBuilder<DateFieldBuilder, DatePicker>,
HasValueBuilder<DateFieldBuilder, DatePicker>,
HasValidationBuilder<DateFieldBuilder, DatePicker>,
HasHelperBuilder<DateFieldBuilder, DatePicker>,
FocusableBuilder<DateFieldBuilder, DatePicker, DatePicker> {
    @Autowired
    protected LocalizedMessageService messageService;
    private final Map<Locale, DatePicker.DatePickerI18n> datePickerI18ns = new HashMap<Locale, DatePicker.DatePickerI18n>();

    public void afterPropertiesSet() throws Exception {
        this.instance = new DatePicker();
        ((DatePicker)this.instance).setWidth(100.0f, Unit.PERCENTAGE);
        ((DatePicker)this.instance).setLocale(this.messageService.getLocale());
        ((DatePicker)this.instance).setI18n(this.getDatePickerI18n(this.messageService.getLocale()));
    }

    public DateFieldBuilder setLocale(Locale locale) {
        ((DatePicker)((JamgoComponentBuilder)this).getComponent()).setLocale(locale);
        return this;
    }

    public DateFieldBuilder setI18n(DatePicker.DatePickerI18n i18n) {
        ((DatePicker)((JamgoComponentBuilder)this).getComponent()).setI18n(i18n);
        return this;
    }

    @Override
    public DatePicker build() {
        Optional.ofNullable(this.label).ifPresent(o -> ((DatePicker)this.instance).setLabel(o));
        return (DatePicker)this.instance;
    }

    private DatePicker.DatePickerI18n getDatePickerI18n(Locale locale) {
        DatePicker.DatePickerI18n datePickerI18n = this.datePickerI18ns.get(locale);
        if (datePickerI18n == null) {
            DayOfWeek firstDayOfWeek = WeekFields.of(locale).getFirstDayOfWeek();
            List monthNames = Stream.of(Month.values()).map(each -> each.getDisplayName(TextStyle.FULL_STANDALONE, locale)).collect(Collectors.toList());
            List weekDays = Stream.of(DayOfWeek.values()).map(each -> each.getDisplayName(TextStyle.FULL_STANDALONE, locale)).collect(Collectors.toList());
            Collections.rotate(weekDays, 1);
            List weekDaysShort = Stream.of(DayOfWeek.values()).map(each -> each.getDisplayName(TextStyle.SHORT, locale)).collect(Collectors.toList());
            Collections.rotate(weekDaysShort, 1);
            datePickerI18n = new DatePicker.DatePickerI18n().setCalendar(this.messageService.getMessage("datePicker.calendar")).setCancel(this.messageService.getMessage("datePicker.cancel")).setClear(this.messageService.getMessage("datePicker.clean")).setToday(this.messageService.getMessage("datePicker.today")).setWeek(this.messageService.getMessage("datePicker.week")).setMonthNames(monthNames).setWeekdays(weekDays).setWeekdaysShort(weekDaysShort).setFirstDayOfWeek(firstDayOfWeek.getValue() % 7);
            this.datePickerI18ns.put(locale, datePickerI18n);
        }
        return datePickerI18n;
    }
}

