/*
 * Decompiled with CFR 0.152.
 */
package org.jamgo.vaadin.ui.builder;

import com.vaadin.flow.component.Component;
import org.jamgo.services.message.LocalizedMessageService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class JamgoComponentBuilder<T extends Component, THIS>
implements InitializingBean {
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected LocalizedMessageService messageSource;
    protected T instance;
    protected String label;

    public T getComponent() {
        return this.instance;
    }

    public T build() {
        return this.instance;
    }

    public THIS setLabel(String label) {
        this.label = label;
        return (THIS)this;
    }

    public THIS setLabelId(String labelId) {
        this.label = this.messageSource.getMessage(labelId);
        return (THIS)this;
    }

    public THIS setLabelId(String labelId, String defaultLabel) {
        this.label = this.messageSource.getMessage(labelId, defaultLabel);
        return (THIS)this;
    }
}

