/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import org.jamon.api.Location;
import org.jamon.codegen.AbstractStatement;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.util.StringUtils;

public class LiteralStatement
extends AbstractStatement {
    private final StringBuilder m_text;

    LiteralStatement(String p_text, Location p_token, String p_templateIdentifier) {
        super(p_token, p_templateIdentifier);
        this.m_text = new StringBuilder(p_text);
    }

    public void appendText(String p_text) {
        this.m_text.append(p_text);
    }

    public void generateSource(CodeWriter p_writer, TemplateDescriber p_describer) {
        if (this.m_text.length() > 0) {
            this.generateSourceLine(p_writer);
            p_writer.print("jamonWriter.write(\"");
            this.javaEscape(this.m_text.toString(), p_writer);
            p_writer.println("\");");
        }
    }

    private void javaEscape(String p_string, CodeWriter p_writer) {
        block7: for (int i = 0; i < p_string.length(); ++i) {
            char c = p_string.charAt(i);
            switch (c) {
                case '\\': {
                    p_writer.print("\\\\");
                    continue block7;
                }
                case '\n': {
                    p_writer.print("\\n");
                    continue block7;
                }
                case '\r': {
                    p_writer.print("\\r");
                    continue block7;
                }
                case '\t': {
                    p_writer.print("\\t");
                    continue block7;
                }
                case '\"': {
                    p_writer.print("\\\"");
                    continue block7;
                }
                default: {
                    char ci = c;
                    if (ci < ' ' || ci > '\u007f') {
                        p_writer.print("\\u");
                        p_writer.print(StringUtils.hexify4(ci));
                        continue block7;
                    }
                    p_writer.print(Character.valueOf(c));
                }
            }
        }
    }

    public String getText() {
        return this.m_text.toString();
    }
}

