/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jamon.api.Location;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.ParamValues;
import org.jamon.codegen.RequiredArgument;
import org.jamon.compiler.ParserErrorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedParamValues
implements ParamValues {
    private final Map<String, String> m_params;
    private final Location m_location;

    public NamedParamValues(Map<String, String> p_params, Location p_location) {
        this.m_params = p_params == null ? Collections.emptyMap() : p_params;
        this.m_location = p_location;
    }

    @Override
    public void generateRequiredArgs(List<RequiredArgument> p_args, CodeWriter p_writer) throws ParserErrorImpl {
        boolean multipleArgsAreMissing = false;
        StringBuilder missingArgs = null;
        for (RequiredArgument arg : p_args) {
            String name = arg.getName();
            String expr = this.m_params.remove(name);
            if (expr == null) {
                if (missingArgs == null) {
                    missingArgs = new StringBuilder(name);
                } else {
                    multipleArgsAreMissing = true;
                    missingArgs.append(", " + name);
                }
            }
            p_writer.printListElement(expr);
        }
        if (missingArgs != null) {
            String plural = multipleArgsAreMissing ? "s" : "";
            throw new ParserErrorImpl(this.m_location, "No value" + plural + " supplied for required argument" + plural + " " + missingArgs.toString());
        }
    }

    @Override
    public String getOptionalArgValue(String p_argName) {
        return this.m_params.remove(p_argName);
    }

    @Override
    public boolean hasUnusedParams() {
        return !this.m_params.isEmpty();
    }

    @Override
    public Iterable<String> getUnusedParams() {
        return this.m_params.keySet();
    }
}

