/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.jamon.codegen.AbstractArgument;
import org.jamon.codegen.AbstractSourceGenerator;
import org.jamon.codegen.AnnotationType;
import org.jamon.codegen.ArgNames;
import org.jamon.codegen.ClassNames;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.MethodUnit;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.PathUtils;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.codegen.TemplateUnit;
import org.jamon.codegen.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyGenerator
extends AbstractSourceGenerator {
    public ProxyGenerator(TemplateDescriber p_describer, TemplateUnit p_templateUnit) {
        super(p_describer, p_templateUnit);
    }

    public void generateSource(OutputStream p_out) throws IOException {
        this.m_writer = new CodeWriter(p_out);
        this.generateHeader();
        this.generatePrologue();
        this.generateImports();
        this.generateAnnotations();
        this.generateDeclaration();
        this.generateConstructors();
        this.generateIntf();
        this.generateImplData();
        if (this.m_templateUnit.getJamonContextType() != null) {
            this.generateJamonContextSetter();
        }
        this.generateOptionalArgs();
        this.generateFragmentInterfaces(false);
        if (!this.m_templateUnit.isParent()) {
            this.generateConstructImpl();
            this.generateMakeRenderer();
            this.generateRender();
        }
        if (this.m_templateUnit.isParent()) {
            this.generateParentRendererClass();
        }
        if (this.m_templateUnit.hasParentPath() && !this.m_templateUnit.isParent()) {
            this.generateMakeParentRenderer();
        }
        this.generateEpilogue();
        this.m_writer.finish();
    }

    private void generateImports() {
        this.m_templateUnit.printImports(this.m_writer);
    }

    private String getClassName() {
        return PathUtils.getIntfClassName(this.m_templateUnit.getName());
    }

    private String getPackageName() {
        return PathUtils.getIntfPackageName(this.m_templateUnit.getName());
    }

    private void generateHeader() {
        this.m_writer.println("// Autogenerated Jamon proxy");
        this.m_writer.println("// " + this.m_describer.getExternalIdentifier(this.m_templateUnit.getName()).replace('\\', '/'));
        this.m_writer.println();
    }

    private void generatePrologue() {
        String pkgName = this.getPackageName();
        if (pkgName.length() > 0) {
            this.m_writer.println("package " + pkgName + ";");
            this.m_writer.println();
        }
    }

    private void generateConstructors() {
        this.m_writer.println();
        this.m_writer.println("public " + this.getClassName() + "(" + ClassNames.TEMPLATE_MANAGER + " p_manager)");
        this.m_writer.openBlock();
        this.m_writer.println(" super(p_manager);");
        this.m_writer.closeBlock();
        this.m_writer.println();
        if (this.m_templateUnit.isParent()) {
            this.m_writer.println("protected " + this.getClassName() + "(String p_path)");
            this.m_writer.openBlock();
            this.m_writer.println("super(p_path);");
            this.m_writer.closeBlock();
            this.m_writer.println();
        } else {
            this.m_writer.println("public " + this.getClassName() + "()");
            this.m_writer.openBlock();
            this.m_writer.println(" super(\"" + this.m_templateUnit.getName() + "\");");
            this.m_writer.closeBlock();
            this.m_writer.println();
        }
    }

    private void generateFragmentInterfaces(boolean p_inner) {
        for (FragmentArgument farg : this.m_templateUnit.getDeclaredFragmentArgs()) {
            farg.getFragmentUnit().printInterface(this.m_writer, "public", !p_inner);
            this.m_writer.println();
        }
        this.m_writer.println();
    }

    private void generateAnnotations() {
        this.m_writer.print("@" + ClassNames.TEMPLATE_ANNOTATION);
        this.m_writer.openList("(", true);
        this.m_writer.printListElement("signature = \"" + this.m_templateUnit.getSignature() + "\"");
        if (this.m_templateUnit.getGenericParams().getCount() > 0) {
            this.m_writer.printListElement("genericsCount = " + this.m_templateUnit.getGenericParams().getCount());
        }
        if (this.m_templateUnit.getInheritanceDepth() > 0) {
            this.m_writer.printListElement("inheritanceDepth = " + this.m_templateUnit.getInheritanceDepth());
        }
        if (this.m_templateUnit.getJamonContextType() != null) {
            this.m_writer.printListElement("jamonContextType = \"" + this.m_templateUnit.getJamonContextType() + "\"");
        }
        this.generateArguments(this.m_templateUnit);
        this.generateMethodAnnotations();
        this.generateAbstractMethodAnnotations();
        this.m_writer.closeList(")");
        this.m_writer.println();
    }

    private void generateMethodAnnotations() {
        if (!this.m_templateUnit.getSignatureMethodUnits().isEmpty()) {
            this.m_writer.printListElement("methods = ");
            this.m_writer.openList("{", true);
            for (MethodUnit methodUnit : this.m_templateUnit.getSignatureMethodUnits()) {
                this.m_writer.printListElement("@" + ClassNames.METHOD_ANNOTATION);
                this.m_writer.openList("(", true);
                this.m_writer.printListElement("name = \"" + methodUnit.getName() + "\"");
                this.generateArguments(methodUnit);
                this.m_writer.closeList(")");
            }
            this.m_writer.closeList("}");
        }
    }

    private void generateAbstractMethodAnnotations() {
        if (!this.m_templateUnit.getAbstractMethodNames().isEmpty()) {
            this.m_writer.printListElement("abstractMethodNames = ");
            this.m_writer.openList("{", false);
            for (String methodName : this.m_templateUnit.getAbstractMethodNames()) {
                this.m_writer.printListElement("\"" + methodName + "\"");
            }
            this.m_writer.closeList("}");
        }
    }

    private void generateArguments(Unit p_unit) {
        this.generateArgumentAnnotations("requiredArguments", p_unit.getSignatureRequiredArgs());
        this.generateArgumentAnnotations("optionalArguments", p_unit.getSignatureOptionalArgs());
        this.generateFragmentAnnotations(p_unit.getFragmentArgs());
    }

    private void generateFragmentAnnotations(Collection<FragmentArgument> p_fargs) {
        if (!p_fargs.isEmpty()) {
            this.m_writer.printListElement("fragmentArguments = ");
            this.m_writer.openList("{", true);
            for (FragmentArgument farg : p_fargs) {
                this.m_writer.printListElement("@" + ClassNames.FRAGMENT_ANNOTATION);
                this.m_writer.openList("(", true);
                this.m_writer.printListElement("name = \"" + farg.getName() + "\"");
                this.generateArgumentAnnotations("requiredArguments", farg.getFragmentUnit().getRequiredArgs());
                this.generateArgumentAnnotations("optionalArguments", farg.getFragmentUnit().getOptionalArgs());
                this.m_writer.closeList(")");
            }
            this.m_writer.closeList("}");
        }
    }

    private void generateArgumentAnnotations(String p_label, Collection<? extends AbstractArgument> p_args) {
        if (!p_args.isEmpty()) {
            this.m_writer.printListElement(p_label + " = ");
            this.m_writer.openList("{", true);
            for (AbstractArgument abstractArgument : p_args) {
                this.m_writer.printListElement("@" + ClassNames.ARGUMENT_ANNOTATION + "(name = \"" + abstractArgument.getName() + "\", type = \"" + abstractArgument.getType() + "\")");
            }
            this.m_writer.closeList("}");
        }
    }

    private void generateDeclaration() {
        this.generateCustomAnnotations(this.m_templateUnit.getAnnotations(), AnnotationType.PROXY);
        this.m_writer.print("public ");
        if (this.m_templateUnit.isParent()) {
            this.m_writer.print("abstract ");
        }
        this.m_writer.println("class " + this.getClassName() + this.m_templateUnit.getGenericParams().generateGenericsDeclaration());
        this.m_writer.println("  extends " + (this.m_templateUnit.hasParentPath() ? PathUtils.getFullyQualifiedIntfClassName(this.m_templateUnit.getParentPath()) : ClassNames.TEMPLATE));
        this.m_templateUnit.printInterfaces(this.m_writer);
        this.m_writer.openBlock();
    }

    private void generateConstructImpl() {
        this.m_writer.println();
        this.m_writer.println("@Override");
        this.m_writer.print("public " + ClassNames.BASE_TEMPLATE + " constructImpl" + "(Class<? extends " + ClassNames.BASE_TEMPLATE + "> p_class)");
        this.m_writer.openBlock();
        this.m_writer.println("try");
        this.m_writer.openBlock();
        this.m_writer.println("return p_class");
        this.m_writer.indent();
        this.m_writer.println(".getConstructor(new Class [] { " + ClassNames.TEMPLATE_MANAGER + ".class" + ", ImplData.class })");
        this.m_writer.println(".newInstance(new Object [] { getTemplateManager(), getImplData()});");
        this.m_writer.outdent();
        this.m_writer.closeBlock();
        this.m_writer.println("catch (RuntimeException e)");
        this.m_writer.openBlock();
        this.m_writer.println("throw e;");
        this.m_writer.closeBlock();
        this.m_writer.println("catch (Exception e)");
        this.m_writer.openBlock();
        this.m_writer.println("throw new RuntimeException(e);");
        this.m_writer.closeBlock();
        this.m_writer.closeBlock();
        this.m_writer.println();
        this.m_writer.println("@Override");
        this.m_writer.print("protected " + ClassNames.BASE_TEMPLATE + " constructImpl()");
        this.m_writer.openBlock();
        this.m_writer.println("return new " + PathUtils.getImplClassName(this.m_templateUnit.getName()) + this.m_templateUnit.getGenericParams().generateGenericParamsList() + "(getTemplateManager(), getImplData());");
        this.m_writer.closeBlock();
    }

    private void generateRender() {
        this.m_writer.print((this.m_templateUnit.isParent() ? "protected" : "public") + " void render");
        this.m_writer.openList();
        this.m_writer.printListElement(ArgNames.WRITER_DECL);
        this.m_templateUnit.printRenderArgsDecl(this.m_writer);
        this.m_writer.closeList();
        this.m_writer.println();
        this.m_writer.println("  throws " + ClassNames.IOEXCEPTION);
        this.m_writer.openBlock();
        this.m_writer.print("renderNoFlush");
        this.m_writer.openList();
        this.m_writer.printListElement("jamonWriter");
        this.m_templateUnit.printRenderArgs(this.m_writer);
        this.m_writer.closeList();
        this.m_writer.println(";");
        this.m_writer.println("jamonWriter.flush();");
        this.m_writer.closeBlock();
        this.m_writer.print((this.m_templateUnit.isParent() ? "protected" : "public") + " void renderNoFlush");
        this.m_writer.openList();
        this.m_writer.printListElement(ArgNames.WRITER_DECL);
        this.m_templateUnit.printRenderArgsDecl(this.m_writer);
        this.m_writer.closeList();
        this.m_writer.println();
        this.m_writer.println("  throws " + ClassNames.IOEXCEPTION);
        this.m_writer.openBlock();
        if (!this.m_templateUnit.getRenderArgs().isEmpty()) {
            this.m_writer.println("ImplData" + this.m_templateUnit.getGenericParams().generateGenericParamsList() + " implData = getImplData();");
            for (AbstractArgument arg : this.m_templateUnit.getRenderArgs()) {
                this.m_writer.println("implData." + arg.getSetterName() + "(" + arg.getName() + ");");
            }
        }
        if (this.m_templateUnit.getGenericParams().getCount() > 0) {
            this.m_writer.print("@SuppressWarnings(\"unchecked\") ");
        }
        this.m_writer.println("Intf instance = (Intf) getTemplateManager().constructImpl(this);");
        this.m_writer.println("instance.renderNoFlush(jamonWriter);");
        this.m_writer.println("reset();");
        this.m_writer.closeBlock();
        this.m_writer.println();
    }

    private void generateMakeRenderer() {
        this.m_writer.print("public " + ClassNames.RENDERER + " makeRenderer");
        this.m_writer.openList();
        this.m_templateUnit.printRenderArgsDecl(this.m_writer);
        this.m_writer.closeList();
        this.m_writer.println();
        this.m_writer.openBlock();
        this.m_writer.print("return new " + ClassNames.ABSTRACT_RENDERER + "() ");
        this.m_writer.openBlock();
        this.m_writer.println("@Override");
        this.m_writer.println("public void renderTo(" + ArgNames.WRITER_DECL + ")");
        this.m_writer.println("  throws " + ClassNames.IOEXCEPTION);
        this.m_writer.openBlock();
        this.m_writer.print("render");
        this.m_writer.openList();
        this.m_writer.printListElement("jamonWriter");
        this.m_templateUnit.printRenderArgs(this.m_writer);
        this.m_writer.closeList();
        this.m_writer.println(";");
        this.m_writer.closeBlock();
        this.m_writer.closeBlock(";");
        this.m_writer.closeBlock();
        this.m_writer.println();
    }

    private void generateImplData() {
        this.m_templateUnit.getGenericParams().suppressGenericHidingWarnings(this.m_writer);
        this.m_writer.println("public static class ImplData" + this.m_templateUnit.getGenericParams().generateGenericsDeclaration());
        this.m_writer.print("  extends ");
        if (this.m_templateUnit.hasParentPath()) {
            this.m_writer.println(PathUtils.getFullyQualifiedIntfClassName(this.m_templateUnit.getParentPath()) + ".ImplData");
        } else {
            this.m_writer.println(ClassNames.IMPL_DATA);
        }
        this.m_writer.openBlock();
        if (this.m_templateUnit.isOriginatingJamonContext()) {
            this.m_writer.println("private " + this.m_templateUnit.getJamonContextType() + " m_jamonContext;");
            this.m_writer.println("public " + this.m_templateUnit.getJamonContextType() + " getJamonContext()");
            this.m_writer.openBlock();
            this.m_writer.println("return m_jamonContext;");
            this.m_writer.closeBlock();
            this.m_writer.println("public void setJamonContext(" + this.m_templateUnit.getJamonContextType() + " p_jamonContext)");
            this.m_writer.openBlock();
            this.m_writer.println("m_jamonContext = p_jamonContext;");
            this.m_writer.closeBlock();
        }
        for (AbstractArgument arg : this.m_templateUnit.getDeclaredArgs()) {
            arg.generateImplDataCode(this.m_writer);
        }
        this.m_writer.closeBlock();
        if (!this.m_templateUnit.isParent()) {
            this.m_writer.println("@Override");
            this.m_writer.println("protected ImplData" + this.m_templateUnit.getGenericParams().generateGenericParamsList() + " makeImplData()");
            this.m_writer.openBlock();
            this.m_writer.println("return new ImplData" + this.m_templateUnit.getGenericParams().generateGenericParamsList() + "();");
            this.m_writer.closeBlock();
        }
        this.m_writer.println("@Override @SuppressWarnings(\"unchecked\") public ImplData" + this.m_templateUnit.getGenericParams().generateGenericParamsList() + " getImplData()");
        this.m_writer.openBlock();
        this.m_writer.println("return (ImplData" + this.m_templateUnit.getGenericParams().generateGenericParamsList() + ") super.getImplData();");
        this.m_writer.closeBlock();
    }

    private void generateJamonContextSetter() {
        this.m_writer.println();
        if (!this.m_templateUnit.isOriginatingJamonContext()) {
            this.m_writer.print("@Override ");
        }
        this.m_writer.print("public ");
        this.printFullProxyType();
        this.m_writer.println(" setJamonContext(" + this.m_templateUnit.getJamonContextType() + " p_jamonContext)");
        this.m_writer.openBlock();
        this.m_writer.println("getImplData().setJamonContext(p_jamonContext);");
        this.m_writer.println("return this;");
        this.m_writer.closeBlock();
    }

    private void generateOptionalArgs() {
        for (OptionalArgument arg : this.m_templateUnit.getDeclaredOptionalArgs()) {
            this.m_writer.println();
            this.m_writer.println("protected " + arg.getType() + " " + arg.getName() + ";");
            this.m_writer.print("public final ");
            this.printFullProxyType();
            this.m_writer.println(" " + arg.getSetterName() + "(" + arg.getType() + " p_" + arg.getName() + ")");
            this.m_writer.openBlock();
            this.m_writer.println("(getImplData())." + arg.getSetterName() + "(p_" + arg.getName() + ");");
            this.m_writer.println("return this;");
            this.m_writer.closeBlock();
        }
    }

    private void printFullProxyType() {
        String pkgName = this.getPackageName();
        if (pkgName.length() > 0) {
            this.m_writer.print(pkgName + ".");
        }
        this.m_writer.print(this.getClassName());
        this.m_writer.print(this.m_templateUnit.getGenericParams().generateGenericsDeclaration());
    }

    private void generateIntf() {
        this.m_templateUnit.getGenericParams().suppressGenericHidingWarnings(this.m_writer);
        this.m_writer.println("protected interface Intf" + this.m_templateUnit.getGenericParams().generateGenericsDeclaration());
        this.m_writer.print("  extends " + (this.m_templateUnit.hasParentPath() ? PathUtils.getFullyQualifiedIntfClassName(this.m_templateUnit.getParentPath()) + ".Intf" : ClassNames.TEMPLATE_INTF));
        this.m_writer.openBlock();
        this.generateFragmentInterfaces(true);
        if (!this.m_templateUnit.isParent()) {
            this.m_writer.println("void renderNoFlush(" + ArgNames.WRITER_DECL + ") throws " + ClassNames.IOEXCEPTION + ";");
            this.m_writer.println();
        }
        this.m_writer.closeBlock();
    }

    private void generateParentRendererClass() {
        this.m_writer.println("public abstract class ParentRenderer");
        this.m_writer.openBlock();
        this.m_writer.println("protected ParentRenderer() {}");
        for (OptionalArgument arg : this.m_templateUnit.getSignatureOptionalArgs()) {
            this.m_writer.println();
            String name = arg.getName();
            this.m_writer.print("public final ParentRenderer ");
            this.m_writer.println(arg.getSetterName() + "(" + arg.getType() + " p_" + name + ")");
            this.m_writer.openBlock();
            this.m_writer.println(this.getClassName() + ".this." + arg.getSetterName() + "(" + "p_" + name + ");");
            this.m_writer.println("return this;");
            this.m_writer.closeBlock();
        }
        if (this.m_templateUnit.getJamonContextType() != null) {
            this.m_writer.print("public final ParentRenderer setJamonContext(" + this.m_templateUnit.getJamonContextType() + " p_jamonContext)");
            this.m_writer.openBlock();
            this.m_writer.println(this.getClassName() + ".this.setJamonContext(p_jamonContext);");
            this.m_writer.println("return this;");
            this.m_writer.closeBlock();
        }
        if (!this.m_templateUnit.hasParentPath()) {
            this.m_writer.print("public void render");
            this.m_writer.openList();
            this.m_writer.printListElement(ArgNames.WRITER_DECL);
            this.m_templateUnit.printDeclaredRenderArgsDecl(this.m_writer);
            this.m_writer.closeList();
            this.m_writer.println();
            this.m_writer.print("  throws " + ClassNames.IOEXCEPTION);
            this.m_writer.openBlock();
            this.m_writer.print("renderNoFlush");
            this.m_writer.openList();
            this.m_writer.printListElement("jamonWriter");
            this.m_templateUnit.printDeclaredRenderArgs(this.m_writer);
            this.m_writer.closeList();
            this.m_writer.println(";");
            this.m_writer.println("jamonWriter.flush();");
            this.m_writer.closeBlock();
            this.m_writer.print("public void renderNoFlush");
            this.m_writer.openList();
            this.m_writer.printListElement(ArgNames.WRITER_DECL);
            this.m_templateUnit.printDeclaredRenderArgsDecl(this.m_writer);
            this.m_writer.closeList();
            this.m_writer.println();
            this.m_writer.print("  throws " + ClassNames.IOEXCEPTION);
            this.m_writer.openBlock();
            this.m_writer.print("renderChild");
            this.m_writer.openList();
            this.m_writer.printListElement("jamonWriter");
            this.m_templateUnit.printDeclaredRenderArgs(this.m_writer);
            this.m_writer.closeList();
            this.m_writer.println(";");
            this.m_writer.closeBlock();
            this.generateMakeRenderer();
        } else {
            this.generateMakeParentRenderer();
        }
        this.m_writer.print("protected abstract void renderChild");
        this.m_writer.openList();
        this.m_writer.printListElement(ArgNames.WRITER_DECL);
        this.m_templateUnit.printRenderArgsDecl(this.m_writer);
        this.m_writer.closeList();
        this.m_writer.println();
        this.m_writer.println("  throws " + ClassNames.IOEXCEPTION + ";");
        this.m_writer.closeBlock();
    }

    private void generateMakeParentRenderer() {
        String parentRendererClass = PathUtils.getFullyQualifiedIntfClassName(this.m_templateUnit.getParentPath()) + ".ParentRenderer";
        this.m_writer.print("public " + parentRendererClass + " makeParentRenderer");
        this.m_writer.openList();
        this.m_templateUnit.printDeclaredRenderArgsDecl(this.m_writer);
        this.m_writer.closeList();
        this.m_writer.println();
        this.m_writer.openBlock();
        this.m_writer.print("return new " + parentRendererClass + "() ");
        this.m_writer.openBlock();
        this.m_writer.print("@Override protected void renderChild");
        this.m_writer.openList();
        this.m_writer.printListElement(ArgNames.WRITER_DECL);
        this.m_templateUnit.printParentRenderArgsDecl(this.m_writer);
        this.m_writer.closeList();
        this.m_writer.println();
        this.m_writer.println("  throws " + ClassNames.IOEXCEPTION);
        this.m_writer.openBlock();
        this.m_writer.print(PathUtils.getFullyQualifiedIntfClassName(this.getClassName()));
        if (this.m_templateUnit.isParent()) {
            this.m_writer.print(".ParentRenderer.this.renderChild");
        } else {
            this.m_writer.print(".this.renderNoFlush");
        }
        this.m_writer.openList();
        this.m_writer.printListElement("jamonWriter");
        this.m_templateUnit.printRenderArgs(this.m_writer);
        this.m_writer.closeList();
        this.m_writer.println(";");
        this.m_writer.closeBlock();
        this.m_writer.closeBlock(";");
        this.m_writer.closeBlock();
    }

    private void generateEpilogue() {
        this.m_writer.println();
        this.m_writer.closeBlock();
    }
}

