/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.security.MessageDigest;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jamon.api.Location;
import org.jamon.codegen.AbstractArgument;
import org.jamon.codegen.AbstractUnit;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.Concatenation;
import org.jamon.codegen.DeclaredMethodUnit;
import org.jamon.codegen.DefUnit;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.GenericParams;
import org.jamon.codegen.InheritedArgs;
import org.jamon.codegen.InheritedUnit;
import org.jamon.codegen.MethodUnit;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.OverriddenMethodUnit;
import org.jamon.codegen.RequiredArgument;
import org.jamon.codegen.SequentialList;
import org.jamon.codegen.TemplateDescription;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AnnotationNode;
import org.jamon.node.ClassNode;
import org.jamon.node.GenericsParamNode;
import org.jamon.node.ImportNode;
import org.jamon.node.ParentArgNode;
import org.jamon.node.StaticImportNode;
import org.jamon.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateUnit
extends AbstractUnit
implements InheritedUnit {
    private InheritedArgs m_inheritedArgs = null;
    private TemplateDescription m_parentDescription = TemplateDescription.EMPTY;
    private final List<RequiredArgument> m_declaredRequiredArgs = new LinkedList<RequiredArgument>();
    private final List<FragmentArgument> m_fragmentArgs = new LinkedList<FragmentArgument>();
    private final Set<OptionalArgument> m_declaredOptionalArgs = new HashSet<OptionalArgument>();
    private final Set<FragmentArgument> m_declaredFragmentArgs = new HashSet<FragmentArgument>();
    private final Map<String, DefUnit> m_defs = new HashMap<String, DefUnit>();
    private final Map<String, MethodUnit> m_methods = new HashMap<String, MethodUnit>();
    private final List<OverriddenMethodUnit> m_overrides = new LinkedList<OverriddenMethodUnit>();
    private final List<ImportNode> m_imports = new LinkedList<ImportNode>();
    private final List<StaticImportNode> m_staticImports = new LinkedList<StaticImportNode>();
    private final List<String> m_interfaces = new LinkedList<String>();
    private String m_parentPath;
    private boolean m_isParent = false;
    private final List<ClassNode> m_classContent = new LinkedList<ClassNode>();
    private final Set<String> m_dependencies = new HashSet<String>();
    private final Set<String> m_callNames = new HashSet<String>();
    private final Collection<String> m_abstractMethodNames = new HashSet<String>();
    private final GenericParams m_genericParams = new GenericParams();
    private String m_jamonContextType;
    private final List<AnnotationNode> m_annotations = new LinkedList<AnnotationNode>();

    public TemplateUnit(String p_path, ParserErrorsImpl p_errors) {
        super(p_path, null, p_errors, null);
    }

    public int getInheritanceDepth() {
        return this.m_parentDescription == null ? 0 : 1 + this.m_parentDescription.getInheritanceDepth();
    }

    public void setParentDescription(TemplateDescription p_parent) {
        this.m_parentDescription = p_parent;
        this.m_fragmentArgs.addAll(p_parent.getFragmentInterfaces());
        this.m_inheritedArgs = new InheritedArgs(this.getParentPath(), p_parent.getRequiredArgs(), p_parent.getOptionalArgs(), p_parent.getFragmentInterfaces(), this.getErrors());
        for (AbstractArgument abstractArgument : new Concatenation<FragmentArgument>((Collection<FragmentArgument>)p_parent.getRequiredArgs(), (Collection<FragmentArgument>)p_parent.getOptionalArgs(), (Collection<FragmentArgument>)p_parent.getFragmentInterfaces())) {
            this.addArgName(abstractArgument);
        }
        this.m_callNames.addAll(p_parent.getMethodUnits().keySet());
        this.m_abstractMethodNames.addAll(p_parent.getAbstractMethodNames());
        if (this.m_jamonContextType == null) {
            this.setJamonContextType(p_parent.getJamonContextType());
        }
    }

    @Override
    public void addParentArg(ParentArgNode p_arg) {
        this.m_inheritedArgs.addParentArg(p_arg);
    }

    @Override
    public List<FragmentArgument> getFragmentArgs() {
        return this.m_fragmentArgs;
    }

    @Override
    public void addFragmentArg(FragmentArgument p_arg) {
        this.m_fragmentArgs.add(p_arg);
        this.m_declaredFragmentArgs.add(p_arg);
    }

    public Collection<FragmentArgument> getDeclaredFragmentArgs() {
        return this.m_declaredFragmentArgs;
    }

    @Override
    public void addRequiredArg(RequiredArgument p_arg) {
        this.m_declaredRequiredArgs.add(p_arg);
    }

    @Override
    public void addOptionalArg(OptionalArgument p_arg) {
        this.m_declaredOptionalArgs.add(p_arg);
    }

    @Override
    public List<RequiredArgument> getSignatureRequiredArgs() {
        return new SequentialList<RequiredArgument>(this.m_parentDescription.getRequiredArgs(), this.m_declaredRequiredArgs);
    }

    @Override
    public Collection<OptionalArgument> getSignatureOptionalArgs() {
        return new Concatenation<OptionalArgument>((Collection<OptionalArgument>)this.m_parentDescription.getOptionalArgs(), (Collection<OptionalArgument>)this.m_declaredOptionalArgs);
    }

    public String getOptionalArgDefault(OptionalArgument p_arg) {
        return this.m_declaredOptionalArgs.contains(p_arg) ? p_arg.getDefault() : this.m_inheritedArgs.getDefaultValue(p_arg);
    }

    @Override
    public Collection<AbstractArgument> getVisibleArgs() {
        return this.m_inheritedArgs == null ? new Concatenation<AbstractArgument>((Collection<AbstractArgument>)this.getDeclaredRenderArgs(), (Collection<AbstractArgument>)this.getDeclaredOptionalArgs()) : new Concatenation<OptionalArgument>((Collection<OptionalArgument>)this.m_inheritedArgs.getVisibleArgs(), (Collection<OptionalArgument>)this.getDeclaredRenderArgs(), this.getDeclaredOptionalArgs());
    }

    public Collection<OptionalArgument> getDeclaredOptionalArgs() {
        return this.m_declaredOptionalArgs;
    }

    public Collection<String> getTemplateDependencies() {
        return this.m_dependencies;
    }

    private void checkCallName(String p_name, Location p_location) {
        if (!this.m_callNames.add(p_name)) {
            this.getErrors().addError("multiple defs and/or methods named " + p_name, p_location);
        }
    }

    public void makeDefUnit(String p_defName, Location p_location) {
        this.checkCallName(p_defName, p_location);
        this.m_defs.put(p_defName, new DefUnit(p_defName, this, this.getErrors(), p_location));
    }

    public Collection<DefUnit> getDefUnits() {
        return this.m_defs.values();
    }

    public DefUnit getDefUnit(String p_name) {
        return this.m_defs.get(p_name);
    }

    public void makeMethodUnit(String p_methodName, Location p_location, boolean p_isAbstract) {
        this.checkCallName(p_methodName, p_location);
        this.m_methods.put(p_methodName, new DeclaredMethodUnit(p_methodName, this, this.getErrors(), p_location, p_isAbstract));
        if (p_isAbstract) {
            this.m_abstractMethodNames.add(p_methodName);
        }
    }

    public OverriddenMethodUnit makeOverridenMethodUnit(String p_name, Location p_location) {
        DeclaredMethodUnit methodUnit = (DeclaredMethodUnit)this.m_parentDescription.getMethodUnits().get(p_name);
        if (methodUnit == null) {
            this.getErrors().addError("There is no such method " + p_name + " to override", p_location);
            methodUnit = new DeclaredMethodUnit(p_name, this, this.getErrors(), p_location);
        }
        this.m_abstractMethodNames.remove(p_name);
        OverriddenMethodUnit override = new OverriddenMethodUnit(methodUnit, this, this.getErrors(), p_location);
        this.m_overrides.add(override);
        return override;
    }

    public MethodUnit getMethodUnit(String p_name) {
        return this.m_methods.containsKey(p_name) ? this.m_methods.get(p_name) : this.m_parentDescription.getMethodUnits().get(p_name);
    }

    public Collection<MethodUnit> getSignatureMethodUnits() {
        return new Concatenation<MethodUnit>(this.getDeclaredMethodUnits(), this.m_parentDescription.getMethodUnits().values());
    }

    public Collection<MethodUnit> getDeclaredMethodUnits() {
        return this.m_methods.values();
    }

    public Collection<MethodUnit> getImplementedMethodUnits() {
        return new Concatenation<MethodUnit>(this.getDeclaredMethodUnits(), (Collection<MethodUnit>)this.m_overrides);
    }

    public Collection<String> getAbstractMethodNames() {
        return this.m_abstractMethodNames;
    }

    private Iterable<ImportNode> getImports() {
        return this.m_imports;
    }

    public void addStaticImport(StaticImportNode p_node) {
        this.m_staticImports.add(p_node);
    }

    private Iterable<StaticImportNode> getStaticImports() {
        return this.m_staticImports;
    }

    public void addImport(ImportNode p_node) {
        this.m_imports.add(p_node);
    }

    public void addInterface(String p_interface) {
        this.m_interfaces.add(p_interface);
    }

    public void setParentPath(String p_parentPath) {
        this.m_parentPath = p_parentPath;
        this.m_dependencies.add(this.m_parentPath);
    }

    public String getParentPath() {
        return this.m_parentPath;
    }

    public boolean hasParentPath() {
        return this.m_parentPath != null;
    }

    public boolean isParent() {
        return this.m_isParent;
    }

    public void setIsParent() {
        this.m_isParent = true;
    }

    public void printClassContent(CodeWriter p_writer) {
        for (ClassNode node : this.m_classContent) {
            p_writer.printLocation(node.getLocation());
            p_writer.println(node.getContent());
        }
    }

    public void addClassContent(ClassNode p_node) {
        this.m_classContent.add(p_node);
    }

    public void addCallPath(String p_callPath) {
        this.m_dependencies.add(p_callPath);
    }

    public Collection<RequiredArgument> getParentRenderArgs() {
        return new Concatenation<RequiredArgument>((Collection<RequiredArgument>)this.m_parentDescription.getRequiredArgs(), (Collection<RequiredArgument>)this.m_parentDescription.getFragmentInterfaces());
    }

    public void printImports(CodeWriter p_writer) {
        for (ImportNode importNode : this.getImports()) {
            p_writer.printLocation(importNode.getLocation());
            p_writer.println("import " + importNode.getName() + ";");
        }
        for (StaticImportNode staticImportNode : this.getStaticImports()) {
            p_writer.printLocation(staticImportNode.getLocation());
            p_writer.println("import static " + staticImportNode.getName() + ";");
        }
        p_writer.println();
    }

    public void printParentRenderArgs(CodeWriter p_writer) {
        TemplateUnit.printArgs(p_writer, this.getParentRenderArgs());
    }

    public void printParentRenderArgsDecl(CodeWriter p_writer) {
        TemplateUnit.printArgsDecl(p_writer, this.getParentRenderArgs());
    }

    public Collection<? extends RequiredArgument> getDeclaredRenderArgs() {
        return new Concatenation<FragmentArgument>((Collection<FragmentArgument>)this.m_declaredRequiredArgs, (Collection<FragmentArgument>)this.m_declaredFragmentArgs);
    }

    public Collection<AbstractArgument> getDeclaredArgs() {
        return new Concatenation<AbstractArgument>((Collection<AbstractArgument>)this.getDeclaredRenderArgs(), (Collection<AbstractArgument>)this.m_declaredOptionalArgs);
    }

    public void printDeclaredRenderArgs(CodeWriter p_writer) {
        TemplateUnit.printArgs(p_writer, this.getDeclaredRenderArgs());
    }

    public void printDeclaredRenderArgsDecl(CodeWriter p_writer) {
        TemplateUnit.printArgsDecl(p_writer, this.getDeclaredRenderArgs());
    }

    public void printInterfaces(CodeWriter p_writer) {
        if (this.m_interfaces.size() > 0) {
            p_writer.print("  implements ");
            p_writer.openList("", false);
            for (String intrface : this.m_interfaces) {
                p_writer.printListElement(intrface);
            }
            p_writer.closeList("");
        }
    }

    @Override
    protected void generateInterfaceSummary(StringBuilder p_buf) {
        super.generateInterfaceSummary(p_buf);
        p_buf.append("GenericParams:");
        p_buf.append(this.getGenericParams().generateGenericsDeclaration());
        p_buf.append("\n");
        if (this.m_parentDescription != null) {
            p_buf.append("Parent sig: ");
            p_buf.append(this.m_parentDescription.getSignature());
            p_buf.append("\n");
        }
        for (FragmentArgument arg : this.getFragmentArgs()) {
            p_buf.append("Fragment: ");
            p_buf.append(arg.getName());
            p_buf.append("\n");
            arg.getFragmentUnit().generateInterfaceSummary(p_buf);
        }
    }

    public String getSignature() {
        try {
            StringBuilder buf = new StringBuilder();
            this.generateInterfaceSummary(buf);
            return StringUtils.byteArrayToHexString(MessageDigest.getInstance("MD5").digest(buf.toString().getBytes("UTF-8")));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate signature", e);
        }
    }

    public GenericParams getGenericParams() {
        return this.m_genericParams;
    }

    public void setJamonContextType(String p_jamonContextType) {
        this.m_jamonContextType = p_jamonContextType;
    }

    public String getJamonContextType() {
        return this.m_jamonContextType;
    }

    public boolean isOriginatingJamonContext() {
        return this.m_jamonContextType != null && (!this.hasParentPath() || this.m_parentDescription.getJamonContextType() == null);
    }

    public void addGenericsParamNode(GenericsParamNode p_node) {
        this.m_genericParams.addParam(p_node);
    }

    public void addAnnotationNode(AnnotationNode p_node) {
        this.m_annotations.add(p_node);
    }

    public Iterable<AnnotationNode> getAnnotations() {
        return this.m_annotations;
    }
}

