/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbstractImportNode;
import org.jamon.node.ImportNode;
import org.jamon.node.StaticImportNode;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.PositionalPushbackReader;

public class ImportParser
extends AbstractParser {
    public static final String MISSING_WHITESPACE_AFTER_STATIC_DECLARATION = "missing whitespace after static declaration";
    private final Location m_location;
    private String m_import;
    private boolean m_isStatic = false;

    public ImportParser(Location p_location, PositionalPushbackReader p_reader, ParserErrorsImpl p_errors) {
        super(p_reader, p_errors);
        this.m_location = p_location;
    }

    public ImportParser(PositionalPushbackReader p_reader, ParserErrorsImpl p_errors) {
        super(p_reader, p_errors);
        this.m_location = this.m_reader.getNextLocation();
    }

    public ImportParser parse() throws IOException, ParserErrorImpl {
        StringBuilder builder = new StringBuilder();
        try {
            String firstComponent = this.readIdentifierOrThrow();
            if ("static".equals(firstComponent)) {
                this.m_isStatic = true;
                if (!this.soakWhitespace()) {
                    throw new ParserErrorImpl(this.m_location, MISSING_WHITESPACE_AFTER_STATIC_DECLARATION);
                }
                firstComponent = this.readIdentifierOrThrow();
            }
            this.soakWhitespace();
            builder.append(firstComponent);
            while (this.readAndAppendChar('.', builder)) {
                this.soakWhitespace();
                if (this.readAndAppendChar('*', builder)) break;
                builder.append(this.readIdentifierOrThrow());
                this.soakWhitespace();
            }
            this.m_import = builder.toString();
            return this;
        }
        catch (AbstractParser.NotAnIdentifierException e) {
            throw new ParserErrorImpl(this.m_location, "Bad java type specifier");
        }
    }

    public AbstractImportNode getNode() {
        return this.m_isStatic ? new StaticImportNode(this.m_location, this.m_import) : new ImportNode(this.m_location, this.m_import);
    }

    public boolean isStatic() {
        return this.m_isStatic;
    }
}

