/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.LinkedList;
import java.util.List;
import org.jamon.api.Location;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.GenericParams;
import org.jamon.codegen.LiteralStatement;
import org.jamon.codegen.Statement;
import org.jamon.codegen.StatementBlock;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.codegen.Unit;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.node.ArgNode;
import org.jamon.node.FragmentArgsNode;
import org.jamon.node.OptionalArgNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStatementBlock
implements StatementBlock {
    private final List<Statement> m_statements = new LinkedList<Statement>();
    private final StatementBlock m_parent;
    private final Location m_location;

    public AbstractStatementBlock(StatementBlock p_parent, Location p_location) {
        this.m_parent = p_parent;
        this.m_location = p_location;
    }

    protected void printStatements(CodeWriter p_writer, TemplateDescriber p_describer) throws ParserErrorImpl {
        for (Statement statement : this.getStatements()) {
            statement.generateSource(p_writer, p_describer);
        }
    }

    @Override
    public FragmentUnit getFragmentUnitIntf(String p_path) {
        return this.getParentUnit().getFragmentUnitIntf(p_path);
    }

    @Override
    public void addStatement(Statement p_statement) {
        if (p_statement instanceof LiteralStatement && !this.m_statements.isEmpty() && this.m_statements.get(this.m_statements.size() - 1) instanceof LiteralStatement) {
            ((LiteralStatement)this.m_statements.get(this.m_statements.size() - 1)).appendText(((LiteralStatement)p_statement).getText());
        } else {
            this.m_statements.add(p_statement);
        }
    }

    public List<Statement> getStatements() {
        return this.m_statements;
    }

    public boolean canThrowIOException() {
        return !this.m_statements.isEmpty();
    }

    @Override
    public FragmentUnit addFragment(FragmentArgsNode p_node, GenericParams p_genericParams) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addRequiredArg(ArgNode p_node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addOptionalArg(OptionalArgNode p_node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Unit getParentUnit() {
        return this.m_parent instanceof Unit ? (Unit)this.m_parent : this.m_parent.getParentUnit();
    }

    @Override
    public StatementBlock getParent() {
        return this.m_parent;
    }

    public Location getLocation() {
        return this.m_location;
    }
}

