/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jamon.api.Location;
import org.jamon.codegen.AbstractArgument;
import org.jamon.codegen.AbstractStatementBlock;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.GenericParams;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.RequiredArgument;
import org.jamon.codegen.SequentialList;
import org.jamon.codegen.StatementBlock;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.codegen.Unit;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.ArgNode;
import org.jamon.node.FragmentArgsNode;
import org.jamon.node.OptionalArgNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUnit
extends AbstractStatementBlock
implements Unit {
    private final String m_name;
    private final ParserErrorsImpl m_errors;
    private final Set<String> m_argNames = new HashSet<String>();

    public AbstractUnit(String p_name, StatementBlock p_parent, ParserErrorsImpl p_errors, Location p_location) {
        super(p_parent, p_location);
        this.m_name = p_name;
        this.m_errors = p_errors;
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    @Override
    public final Unit getParentUnit() {
        return (Unit)this.getParent();
    }

    protected final ParserErrorsImpl getErrors() {
        return this.m_errors;
    }

    protected abstract void addFragmentArg(FragmentArgument var1);

    @Override
    public abstract List<FragmentArgument> getFragmentArgs();

    @Override
    public FragmentUnit getFragmentUnitIntf(String p_path) {
        for (FragmentArgument arg : this.getFragmentArgs()) {
            if (!p_path.equals(arg.getName())) continue;
            return arg.getFragmentUnit();
        }
        return null;
    }

    @Override
    public void generateRenderBody(CodeWriter p_writer, TemplateDescriber p_describer) throws ParserErrorImpl {
        p_writer.openBlock();
        this.printStatements(p_writer, p_describer);
        p_writer.closeBlock();
    }

    public abstract void addRequiredArg(RequiredArgument var1);

    public abstract void addOptionalArg(OptionalArgument var1);

    @Override
    public abstract List<RequiredArgument> getSignatureRequiredArgs();

    @Override
    public abstract Collection<OptionalArgument> getSignatureOptionalArgs();

    public abstract Collection<AbstractArgument> getVisibleArgs();

    @Override
    public FragmentUnit addFragment(FragmentArgsNode p_node, GenericParams p_genericParams) {
        this.checkArgName(p_node.getFragmentName(), p_node.getLocation());
        FragmentUnit frag = new FragmentUnit(p_node.getFragmentName(), this, p_genericParams, this.m_errors, p_node.getLocation());
        this.addFragmentArg(new FragmentArgument(frag, p_node.getLocation()));
        return frag;
    }

    @Override
    public void addRequiredArg(ArgNode p_node) {
        this.checkArgName(p_node.getName().getName(), p_node.getName().getLocation());
        this.addRequiredArg(new RequiredArgument(p_node));
    }

    @Override
    public void addOptionalArg(OptionalArgNode p_node) {
        this.checkArgName(p_node.getName().getName(), p_node.getName().getLocation());
        this.addOptionalArg(new OptionalArgument(p_node));
    }

    protected void addArgName(AbstractArgument p_arg) {
        this.m_argNames.add(p_arg.getName());
    }

    private void checkArgName(String p_name, Location p_location) {
        if (!this.m_argNames.add(p_name)) {
            this.getErrors().addError("multiple arguments named " + p_name, p_location);
        }
    }

    public List<AbstractArgument> getRenderArgs() {
        return new SequentialList<AbstractArgument>(this.getSignatureRequiredArgs(), this.getFragmentArgs());
    }

    @Override
    public void printRenderArgsDecl(CodeWriter p_writer) {
        AbstractUnit.printArgsDecl(p_writer, this.getRenderArgs());
    }

    public void printRenderArgs(CodeWriter p_writer) {
        AbstractUnit.printArgs(p_writer, this.getRenderArgs());
    }

    protected static void printArgsDecl(CodeWriter p_writer, Iterable<? extends AbstractArgument> i) {
        for (AbstractArgument abstractArgument : i) {
            p_writer.printListElement("final " + abstractArgument.getType() + " " + abstractArgument.getName());
        }
    }

    protected static void printArgs(CodeWriter p_writer, Iterable<? extends AbstractArgument> p_args) {
        for (AbstractArgument abstractArgument : p_args) {
            p_writer.printListElement(abstractArgument.getName());
        }
    }

    protected void generateInterfaceSummary(StringBuilder p_buf) {
        p_buf.append("Required\n");
        for (RequiredArgument arg : this.getSignatureRequiredArgs()) {
            p_buf.append(arg.getName());
            p_buf.append(":");
            p_buf.append(arg.getType());
            p_buf.append("\n");
        }
        p_buf.append("Optional\n");
        TreeMap<String, OptionalArgument> optArgs = new TreeMap<String, OptionalArgument>();
        for (OptionalArgument arg : this.getSignatureOptionalArgs()) {
            optArgs.put(arg.getName(), arg);
        }
        for (OptionalArgument arg : optArgs.values()) {
            p_buf.append(arg.getName());
            p_buf.append(":");
            p_buf.append(arg.getType());
            p_buf.append("\n");
        }
    }
}

