/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class EncodingReader
extends Reader {
    private final Reader m_reader;
    private int m_bytesRead;
    private static final byte[] ONEBYTESIG;
    private static final byte[] UTF16LESIG;
    private static final byte[] UTF16BESIG;
    private static final int SPACE = 32;
    private static final int TAB = 9;
    private static final int CLOSE = 62;
    private static final int INNAME = 1;
    private static final int WAITFORCLOSE = 2;
    private static final int CLOSED = 3;

    public EncodingReader(InputStream p_stream) throws IOException {
        PushbackInputStream stream = new PushbackInputStream(p_stream, 50);
        this.m_reader = this.matches(ONEBYTESIG, stream) ? new InputStreamReader((InputStream)stream, this.computeOneByteEncoding(stream)) : (this.matches(UTF16LESIG, stream) || this.matches(UTF16BESIG, stream) ? new InputStreamReader((InputStream)stream, this.computeUtf16Encoding(stream)) : new InputStreamReader(stream));
    }

    private boolean matches(byte[] match, PushbackInputStream p_stream) throws IOException {
        byte[] data = new byte[match.length];
        int len = p_stream.read(data);
        if (len == -1) {
            return false;
        }
        if (len == match.length) {
            for (int i = 0; i < len; ++i) {
                if (match[i] == data[i]) continue;
                p_stream.unread(data, 0, len);
                return false;
            }
            this.m_bytesRead = len;
            return true;
        }
        p_stream.unread(data, 0, len);
        return false;
    }

    private String computeUtf16Encoding(PushbackInputStream p_stream) throws IOException {
        return this.computeEncoding(p_stream, true);
    }

    private String computeOneByteEncoding(PushbackInputStream p_stream) throws IOException {
        return this.computeEncoding(p_stream, false);
    }

    private String computeEncoding(PushbackInputStream p_stream, boolean p_twoBytes) throws IOException {
        StringBuilder encoding;
        block9: {
            encoding = new StringBuilder();
            boolean lowByte = true;
            int state = 0;
            while (true) {
                int c = p_stream.read();
                ++this.m_bytesRead;
                if (p_twoBytes) {
                    if (lowByte) {
                        if (c != 0) {
                            throw new Exception("Malformed encoding name", this.m_bytesRead / (p_twoBytes ? 2 : 1));
                        }
                        lowByte = false;
                        continue;
                    }
                    lowByte = true;
                }
                if (c == -1) {
                    throw new Exception("EOF before encoding tag finished", this.m_bytesRead / (p_twoBytes ? 2 : 1));
                }
                if (c == 32 || c == 9) {
                    if (state != true) continue;
                    state = 2;
                    continue;
                }
                if (c == 62) {
                    state = 3;
                    continue;
                }
                if (state == 3) {
                    if (c == 13 || c == 10) continue;
                    p_stream.unread(c);
                    if (p_twoBytes) {
                        p_stream.unread(0);
                    }
                    break block9;
                }
                if (state == 2) break;
                state = 1;
                encoding.append((char)c);
            }
            throw new Exception("Malformed encoding tag; expected '>'", this.m_bytesRead / (p_twoBytes ? 2 : 1));
        }
        return encoding.toString();
    }

    public void close() throws IOException {
        this.m_reader.close();
    }

    public int read(char[] p_buf, int p_offset, int p_len) throws IOException {
        return this.m_reader.read(p_buf, p_offset, p_len);
    }

    static {
        try {
            ONEBYTESIG = "<%encoding ".getBytes("latin1");
            UTF16BESIG = "<%encoding ".getBytes("UTF-16BE");
            UTF16LESIG = "<%encoding ".getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static class Exception
    extends IOException {
        private static final long serialVersionUID = 2006091701L;
        private final int m_pos;

        public Exception(String p_message, int p_pos) {
            super(p_message);
            this.m_pos = p_pos;
        }

        public int getPos() {
            return this.m_pos;
        }
    }
}

