/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.io.IOException;
import java.io.OutputStream;
import org.jamon.codegen.AbstractArgument;
import org.jamon.codegen.AbstractSourceGenerator;
import org.jamon.codegen.AnnotationType;
import org.jamon.codegen.ArgNames;
import org.jamon.codegen.ClassNames;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.DefUnit;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.MethodUnit;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.PathUtils;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.codegen.TemplateUnit;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;

public class ImplGenerator
extends AbstractSourceGenerator {
    private static final String SET_OPTS = "__jamon_setOptionalArguments";

    public ImplGenerator(TemplateDescriber p_describer, TemplateUnit p_templateUnit) {
        super(p_describer, p_templateUnit);
    }

    public void generateSource(OutputStream p_out) throws IOException {
        this.m_writer = new CodeWriter(p_out);
        try {
            this.generateHeader();
            this.generatePrologue();
            this.generateImports();
            this.generateDeclaration();
            this.generateSetOptionalArguments();
            this.generateConstructor();
            this.generateRender();
            this.generateDefs();
            this.generateMethods();
            this.generateEpilogue();
            this.m_writer.finish();
        }
        catch (ParserErrorImpl e) {
            throw new ParserErrorsImpl(e);
        }
    }

    private final String getPath() {
        return this.m_templateUnit.getName();
    }

    private String getClassName() {
        return PathUtils.getImplClassName(this.getPath());
    }

    private void generateHeader() {
        this.m_writer.println("// Autogenerated Jamon implementation");
        this.m_writer.println("// " + this.m_describer.getExternalIdentifier(this.getPath()).replace('\\', '/'));
        this.m_writer.println();
    }

    private void generateDeclaration() {
        this.generateCustomAnnotations(this.m_templateUnit.getAnnotations(), AnnotationType.IMPL);
        this.m_writer.print("public");
        if (this.m_templateUnit.isParent()) {
            this.m_writer.print(" abstract");
        }
        this.m_writer.println(" class " + this.getClassName() + this.m_templateUnit.getGenericParams().generateGenericsDeclaration());
        this.m_writer.println("  extends " + (this.m_templateUnit.hasParentPath() ? PathUtils.getFullyQualifiedImplClassName(this.m_templateUnit.getParentPath()) : ClassNames.BASE_TEMPLATE));
        this.m_writer.println("  implements " + this.getProxyClassName() + ".Intf" + this.m_templateUnit.getGenericParams().generateGenericParamsList());
        this.m_writer.println();
        this.m_writer.openBlock();
        if (this.m_templateUnit.getJamonContextType() != null) {
            this.m_writer.println("protected final " + this.m_templateUnit.getJamonContextType() + " jamonContext;");
        }
        for (AbstractArgument arg : this.m_templateUnit.getVisibleArgs()) {
            this.m_writer.println("private final " + arg.getType() + " " + arg.getName() + ";");
        }
        this.m_templateUnit.printClassContent(this.m_writer);
    }

    private void generateSetOptionalArguments() {
        this.m_writer.println("protected static " + this.m_templateUnit.getGenericParams().generateGenericsDeclaration() + this.getImplDataClassName() + " " + SET_OPTS + "(" + this.getImplDataClassName() + " p_implData)");
        this.m_writer.openBlock();
        for (OptionalArgument arg : this.m_templateUnit.getSignatureOptionalArgs()) {
            String value = this.m_templateUnit.getOptionalArgDefault(arg);
            if (value == null) continue;
            this.m_writer.println("if(! p_implData." + arg.getIsNotDefaultName() + "())");
            this.m_writer.openBlock();
            this.m_writer.println("p_implData." + arg.getSetterName() + "(" + value + ");");
            this.m_writer.closeBlock();
        }
        if (this.m_templateUnit.hasParentPath()) {
            this.m_writer.println(this.getParentImplClassName() + "." + SET_OPTS + "(p_implData);");
        }
        this.m_writer.println("return p_implData;");
        this.m_writer.closeBlock();
    }

    private void generateConstructor() {
        this.m_writer.println("public " + this.getClassName() + "(" + ClassNames.TEMPLATE_MANAGER + " p_templateManager, " + this.getImplDataClassName() + " p_implData)");
        this.m_writer.openBlock();
        this.m_writer.println("super(p_templateManager, __jamon_setOptionalArguments(p_implData));");
        if (this.m_templateUnit.getJamonContextType() != null) {
            this.m_writer.println("jamonContext = p_implData.getJamonContext();");
        }
        for (AbstractArgument arg : this.m_templateUnit.getVisibleArgs()) {
            this.m_writer.println(arg.getName() + " = p_implData." + arg.getGetterName() + "();");
        }
        this.m_writer.closeBlock();
        this.m_writer.println();
    }

    private void generatePrologue() {
        String pkgName = PathUtils.getImplPackageName(this.getPath());
        if (pkgName.length() > 0) {
            this.m_writer.println("package " + pkgName + ";");
            this.m_writer.println();
        }
    }

    private void generateInnerUnitFargInterface(FragmentUnit p_fragmentUnit, boolean p_private) {
        this.m_writer.println();
        this.m_writer.printLocation(p_fragmentUnit.getLocation());
        p_fragmentUnit.printInterface(this.m_writer, p_private ? "private" : "protected", false);
    }

    private void generateDefs() throws ParserErrorImpl {
        for (DefUnit defUnit : this.m_templateUnit.getDefUnits()) {
            for (FragmentArgument frag : defUnit.getFragmentArgs()) {
                this.generateInnerUnitFargInterface(frag.getFragmentUnit(), true);
            }
            this.m_writer.println();
            this.m_writer.printLocation(defUnit.getLocation());
            this.m_writer.print("private void __jamon_innerUnit__");
            this.m_writer.print(defUnit.getName());
            this.m_writer.openList();
            this.m_writer.printListElement(ArgNames.ANNOTATED_WRITER_DECL);
            defUnit.printRenderArgsDecl(this.m_writer);
            this.m_writer.closeList();
            this.m_writer.println();
            if (defUnit.canThrowIOException()) {
                this.m_writer.println("  throws " + ClassNames.IOEXCEPTION);
            }
            defUnit.generateRenderBody(this.m_writer, this.m_describer);
            this.m_writer.println();
        }
    }

    private void generateMethods() throws ParserErrorImpl {
        for (MethodUnit methodUnit : this.m_templateUnit.getDeclaredMethodUnits()) {
            this.generateMethodIntf(methodUnit);
        }
        for (MethodUnit methodUnit : this.m_templateUnit.getImplementedMethodUnits()) {
            this.generateMethodImpl(methodUnit);
        }
    }

    private void generateMethodIntf(MethodUnit p_methodUnit) {
        this.m_writer.println();
        for (FragmentArgument frag : p_methodUnit.getFragmentArgs()) {
            this.generateInnerUnitFargInterface(frag.getFragmentUnit(), false);
        }
    }

    private void generateMethodImpl(MethodUnit p_methodUnit) throws ParserErrorImpl {
        this.m_writer.println();
        this.m_writer.printLocation(p_methodUnit.getLocation());
        if (p_methodUnit.isOverride()) {
            this.m_writer.print("@Override ");
        }
        this.m_writer.print("protected " + (p_methodUnit.isAbstract() ? "abstract " : "") + "void __jamon_innerUnit__");
        this.m_writer.print(p_methodUnit.getName());
        this.m_writer.openList();
        this.m_writer.printListElement(ArgNames.ANNOTATED_WRITER_DECL);
        p_methodUnit.printRenderArgsDecl(this.m_writer);
        this.m_writer.closeList();
        this.m_writer.println();
        if (p_methodUnit.canThrowIOException()) {
            this.m_writer.println("  throws " + ClassNames.IOEXCEPTION);
        }
        if (p_methodUnit.isAbstract()) {
            this.m_writer.println("  ;");
        } else {
            p_methodUnit.generateRenderBody(this.m_writer, this.m_describer);
        }
        this.m_writer.println();
        for (OptionalArgument arg : p_methodUnit.getOptionalArgsWithDefaults()) {
            if (p_methodUnit.isOverride()) {
                this.m_writer.print("@Override ");
            }
            this.m_writer.println("protected " + arg.getType() + " " + p_methodUnit.getOptionalArgDefaultMethod(arg) + "()");
            this.m_writer.openBlock();
            this.m_writer.println("return " + p_methodUnit.getDefaultForArg(arg) + ";");
            this.m_writer.closeBlock();
        }
    }

    private void generateRender() throws ParserErrorImpl {
        if (this.m_templateUnit.hasParentPath()) {
            this.m_writer.println("@Override protected void child_render_" + this.m_templateUnit.getInheritanceDepth() + "(" + ArgNames.ANNOTATED_WRITER_DECL + ")");
        } else {
            this.m_writer.println("public void renderNoFlush(" + ArgNames.ANNOTATED_WRITER_DECL + ")");
        }
        if (this.m_templateUnit.canThrowIOException()) {
            this.m_writer.println("  throws " + ClassNames.IOEXCEPTION);
        }
        this.m_templateUnit.generateRenderBody(this.m_writer, this.m_describer);
        this.m_writer.println();
        if (this.m_templateUnit.isParent()) {
            this.m_writer.println("protected abstract void child_render_" + (this.m_templateUnit.getInheritanceDepth() + 1) + "(" + ArgNames.WRITER_DECL + ") throws " + ClassNames.IOEXCEPTION + ";");
            this.m_writer.println();
        }
    }

    private void generateEpilogue() {
        this.m_writer.println();
        this.m_writer.closeBlock();
    }

    private void generateImports() {
        this.m_templateUnit.printImports(this.m_writer);
    }

    private String getProxyClassName() {
        return PathUtils.getFullyQualifiedIntfClassName(this.getPath());
    }

    private String getImplDataClassName() {
        return this.getProxyClassName() + ".ImplData" + this.m_templateUnit.getGenericParams().generateGenericParamsList();
    }

    private String getParentImplClassName() {
        return PathUtils.getFullyQualifiedImplClassName(this.m_templateUnit.getParentPath());
    }
}

