/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import org.jamon.codegen.AbstractArgument;
import org.jamon.codegen.CodeWriter;
import org.jamon.node.OptionalArgNode;
import org.jamon.util.StringUtils;

public class OptionalArgument
extends AbstractArgument {
    private String m_default;

    public OptionalArgument(OptionalArgNode p_arg) {
        super(p_arg);
        this.m_default = p_arg.getValue().getValue();
    }

    public OptionalArgument(String p_name, String p_type, String p_default) {
        super(p_name, p_type, null);
        this.m_default = p_default;
    }

    public void setDefault(String p_default) {
        this.m_default = p_default;
    }

    public String getDefault() {
        return this.m_default;
    }

    public String getIsNotDefaultName() {
        return "get" + StringUtils.capitalize(this.getName()) + "__IsNotDefault";
    }

    public void generateImplDataCode(CodeWriter p_writer) {
        super.generateImplDataCode(p_writer);
        p_writer.println("public boolean " + this.getIsNotDefaultName() + "()");
        p_writer.openBlock();
        p_writer.println("return m_" + this.getName() + "__IsNotDefault;");
        p_writer.closeBlock();
        p_writer.println("private boolean m_" + this.getName() + "__IsNotDefault;");
    }

    protected void generateImplDataSetterCode(CodeWriter p_writer) {
        super.generateImplDataSetterCode(p_writer);
        p_writer.println("m_" + this.getName() + "__IsNotDefault = true;");
    }
}

